/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.cs.internal;

import com.db4o.cs.internal.ClientObjectContainer;
import com.db4o.cs.internal.messages.Msg;
import com.db4o.cs.internal.messages.MsgD;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ArrayType;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.DeleteInfo;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeIntObject;
import com.db4o.internal.ids.TransactionalIdSystem;
import com.db4o.internal.references.ReferenceSystem;

public final class ClientTransaction
extends Transaction {
    private final ClientObjectContainer _client;
    protected Tree _objectRefrencesToGC;

    ClientTransaction(ClientObjectContainer container, Transaction parentTransaction, ReferenceSystem referenceSystem) {
        super(container, parentTransaction, referenceSystem);
        this._client = container;
    }

    public void commit() {
        this.preCommit();
        if (this.isSystemTransaction()) {
            this._client.write(Msg.COMMIT_SYSTEMTRANS);
        } else {
            this._client.write(Msg.COMMIT.getWriter(this));
            this._client.expectedResponse(Msg.OK);
        }
    }

    public void preCommit() {
        this.commitTransactionListeners();
        this.clearAll();
    }

    protected void clear() {
        this.removeObjectReferences();
    }

    private void removeObjectReferences() {
        if (this._objectRefrencesToGC != null) {
            this._objectRefrencesToGC.traverse(new Visitor4(){

                public void visit(Object a_object) {
                    ObjectReference yo = (ObjectReference)((TreeIntObject)a_object)._object;
                    ClientTransaction.this.removeReference(yo);
                }
            });
        }
        this._objectRefrencesToGC = null;
    }

    public boolean delete(ObjectReference ref, int id, int cascade) {
        if (!super.delete(ref, id, cascade)) {
            return false;
        }
        MsgD msg = Msg.TA_DELETE.getWriterForInts(this, id, cascade);
        this._client.writeBatchedMessage(msg);
        return true;
    }

    public void processDeletes() {
        Visitor4 deleteVisitor = new Visitor4(){

            public void visit(Object a_object) {
                DeleteInfo info = (DeleteInfo)a_object;
                if (info._reference != null) {
                    ClientTransaction.this._objectRefrencesToGC = Tree.add(ClientTransaction.this._objectRefrencesToGC, new TreeIntObject<ObjectReference>(info._key, info._reference));
                }
            }
        };
        this.traverseDelete(deleteVisitor);
        this._client.writeBatchedMessage(Msg.PROCESS_DELETES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        Object object = this.container().lock();
        synchronized (object) {
            this._objectRefrencesToGC = null;
            this.rollBackTransactionListeners();
            this.clearAll();
        }
    }

    public void writeUpdateAdjustIndexes(int id, ClassMetadata classMetadata, ArrayType arrayType) {
    }

    public TransactionalIdSystem idSystem() {
        return null;
    }

    public long versionForId(int id) {
        MsgD msg = Msg.VERSION_FOR_ID.getWriterForInt(this.systemTransaction(), id);
        this._client.write(msg);
        return this._client.expectedBufferResponse(Msg.VERSION_FOR_ID).readLong();
    }

    public long generateTransactionTimestamp(long forcedTimeStamp) {
        this._client.writeMsg(Msg.GENERATE_TRANSACTION_TIMESTAMP.getWriterForLong(this, forcedTimeStamp), true);
        return this._client.expectedBufferResponse(Msg.GENERATE_TRANSACTION_TIMESTAMP).readLong();
    }

    public void useDefaultTransactionTimestamp() {
        this._client.writeMsg(Msg.USE_DEFAULT_TRANSACTION_TIMESTAMP, true);
    }
}

