/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.cs.internal;

import com.db4o.cs.internal.ClientObjectContainer;
import com.db4o.cs.internal.messages.Msg;
import com.db4o.foundation.SimpleTimer;
import com.db4o.internal.Config4Impl;

public class ClientHeartbeat
implements Runnable {
    private SimpleTimer _timer;
    private final ClientObjectContainer _container;

    public ClientHeartbeat(ClientObjectContainer container) {
        this._container = container;
        this._timer = new SimpleTimer(this, this.frequency(container.configImpl()));
    }

    private int frequency(Config4Impl config) {
        return Math.min(config.timeoutClientSocket(), config.timeoutServerSocket()) / 4;
    }

    public void run() {
        this._container.writeMessageToSocket(Msg.PING);
    }

    public void start() {
        this._container.threadPool().start("db4o client heartbeat", this._timer);
    }

    public void stop() {
        if (this._timer == null) {
            return;
        }
        this._timer.stop();
        this._timer = null;
    }
}

