/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.cs.internal;

import com.db4o.cs.internal.ClientObjectContainer;
import com.db4o.cs.internal.Socket4Adapter;
import com.db4o.cs.internal.messages.Msg;
import com.db4o.cs.internal.messages.MsgBlob;
import com.db4o.foundation.NonblockingQueue;
import com.db4o.foundation.Queue4;

class BlobProcessor
implements Runnable {
    private ClientObjectContainer stream;
    private Queue4 queue = new NonblockingQueue();
    private boolean terminated = false;

    BlobProcessor(ClientObjectContainer aStream) {
        this.stream = aStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(MsgBlob msg) {
        Queue4 queue4 = this.queue;
        synchronized (queue4) {
            this.queue.add(msg);
        }
    }

    synchronized boolean isTerminated() {
        return this.terminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            Socket4Adapter socket = this.stream.createParallelSocket();
            MsgBlob msg = null;
            Object object = this.queue;
            // MONITORENTER : object
            msg = (MsgBlob)this.queue.next();
            // MONITOREXIT : object
            while (msg != null) {
                msg.write(socket);
                msg.processClient(socket);
                object = this.stream._blobLock;
                // MONITORENTER : object
                Queue4 queue4 = this.queue;
                // MONITORENTER : queue4
                msg = (MsgBlob)this.queue.next();
                // MONITOREXIT : queue4
                if (msg == null) {
                    this.terminated = true;
                    Msg.CLOSE_SOCKET.write(socket);
                    try {
                        socket.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                // MONITOREXIT : object
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

