/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.consistency;

import com.db4o.consistency.SlotDetail;
import com.db4o.foundation.ByRef;
import com.db4o.foundation.Pair;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.BlockConverter;
import com.db4o.internal.TreeIntObject;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OverlapMap {
    private Set<Pair<SlotDetail, SlotDetail>> _dupes = new HashSet<Pair<SlotDetail, SlotDetail>>();
    private TreeIntObject _slots = null;
    private final BlockConverter _blockConverter;

    public OverlapMap(BlockConverter blockConverter) {
        this._blockConverter = blockConverter;
    }

    public void add(SlotDetail slot) {
        if (TreeIntObject.find(this._slots, new TreeIntObject(slot._slot.address())) != null) {
            this._dupes.add(new Pair<SlotDetail, SlotDetail>(this.byAddress(slot._slot.address()), slot));
        }
        this._slots = TreeIntObject.add(this._slots, new TreeIntObject<SlotDetail>(slot._slot.address(), slot));
    }

    public Set<Pair<SlotDetail, SlotDetail>> overlaps() {
        final HashSet<Pair<SlotDetail, SlotDetail>> overlaps = new HashSet<Pair<SlotDetail, SlotDetail>>();
        final ByRef prevSlot = ByRef.newInstance();
        TreeIntObject.traverse(this._slots, new Visitor4<TreeIntObject>(){

            @Override
            public void visit(TreeIntObject tree) {
                SlotDetail curSlot = (SlotDetail)tree._object;
                if (this.isOverlap((SlotDetail)prevSlot.value, curSlot)) {
                    overlaps.add(new Pair(prevSlot.value, curSlot));
                }
                prevSlot.value = curSlot;
            }

            private boolean isOverlap(SlotDetail prevSlot2, SlotDetail curSlot) {
                if (prevSlot2 == null) {
                    return false;
                }
                return prevSlot2._slot.address() + OverlapMap.this._blockConverter.bytesToBlocks(prevSlot2._slot.length()) > curSlot._slot.address();
            }
        });
        return overlaps;
    }

    public Set<Pair<SlotDetail, SlotDetail>> dupes() {
        return this._dupes;
    }

    private SlotDetail byAddress(int address) {
        TreeIntObject tree = (TreeIntObject)TreeIntObject.find(this._slots, new TreeIntObject<Object>(address, null));
        return tree == null ? null : (SlotDetail)tree._object;
    }
}

