/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.config;

import com.db4o.StaticClass;
import com.db4o.StaticField;
import com.db4o.config.Configuration;
import com.db4o.config.ConfigurationItem;
import com.db4o.config.TypeAlias;
import com.db4o.config.WildcardAlias;
import com.db4o.ext.Db4oException;
import com.db4o.internal.InternalObjectContainer;
import com.db4o.internal.Platform4;
import com.db4o.internal.handlers.NetTypeHandler;

public class DotnetSupport
implements ConfigurationItem {
    private final boolean _addCSSupport;

    public DotnetSupport() {
        this._addCSSupport = false;
    }

    public DotnetSupport(boolean addCSSupport) {
        this._addCSSupport = addCSSupport;
    }

    public void prepare(Configuration config) {
        config.addAlias(new WildcardAlias("Db4objects.Db4o.Ext.*, Db4objects.Db4o", "com.db4o.ext.*"));
        config.addAlias(new TypeAlias("Db4objects.Db4o.StaticField, Db4objects.Db4o", StaticField.class.getName()));
        config.addAlias(new TypeAlias("Db4objects.Db4o.StaticClass, Db4objects.Db4o", StaticClass.class.getName()));
        if (this._addCSSupport) {
            ConfigurationItem dotNetCS;
            try {
                dotNetCS = (ConfigurationItem)Class.forName("com.db4o.cs.internal.config.DotNetSupportClientServer").newInstance();
            }
            catch (Exception e) {
                throw new Db4oException(e);
            }
            dotNetCS.prepare(config);
        }
    }

    public void apply(InternalObjectContainer container) {
        NetTypeHandler[] handlers = Platform4.jdk().netTypes(container.reflector());
        for (int netTypeIdx = 0; netTypeIdx < handlers.length; ++netTypeIdx) {
            NetTypeHandler handler = handlers[netTypeIdx];
            container.handlers().registerNetTypeHandler(handler);
        }
    }
}

