/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.tree;

import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.MemRefExpr;
import EDU.purdue.cs.bloat.tree.TreeVisitor;

public class ArrayRefExpr
extends MemRefExpr {
    Expr array;
    Expr index;
    Type elementType;

    public ArrayRefExpr(Expr array, Expr index, Type elementType, Type type) {
        super(type);
        this.array = array;
        this.index = index;
        this.elementType = elementType;
        array.setParent(this);
        index.setParent(this);
    }

    public Expr array() {
        return this.array;
    }

    public Expr index() {
        return this.index;
    }

    public Type elementType() {
        return this.elementType;
    }

    public void visitForceChildren(TreeVisitor visitor) {
        if (visitor.reverse()) {
            this.index.visit(visitor);
            this.array.visit(visitor);
        } else {
            this.array.visit(visitor);
            this.index.visit(visitor);
        }
    }

    public void visit(TreeVisitor visitor) {
        visitor.visitArrayRefExpr(this);
    }

    public int exprHashCode() {
        return 4 + this.array.exprHashCode() ^ this.index.exprHashCode();
    }

    public boolean equalsExpr(Expr other) {
        return other != null && other instanceof ArrayRefExpr && ((ArrayRefExpr)other).array.equalsExpr(this.array) && ((ArrayRefExpr)other).index.equalsExpr(this.index);
    }

    public Object clone() {
        return this.copyInto(new ArrayRefExpr((Expr)this.array.clone(), (Expr)this.index.clone(), this.elementType, this.type));
    }
}

