/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.io;

import com.db4o.foundation.Hashtable4;
import com.db4o.io.IoAdapter;
import java.io.IOException;

public class MemoryIoAdapter
extends IoAdapter {
    private byte[] _bytes;
    private int _length;
    private int _seekPos;
    private Hashtable4 _memoryFiles;
    private int _growBy;

    public MemoryIoAdapter() {
        this._memoryFiles = new Hashtable4(1);
        this._growBy = 10000;
    }

    private MemoryIoAdapter(MemoryIoAdapter memoryIoAdapter, String string, byte[] byArray) {
        this._bytes = byArray;
        this._length = byArray.length;
        this._growBy = memoryIoAdapter._growBy;
    }

    private MemoryIoAdapter(MemoryIoAdapter memoryIoAdapter, String string, int n) {
        this(memoryIoAdapter, string, new byte[n]);
    }

    public void put(String string, byte[] byArray) {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this._memoryFiles.put(string, (Object)new MemoryIoAdapter(this, string, byArray));
    }

    public byte[] get(String string) {
        MemoryIoAdapter memoryIoAdapter = (MemoryIoAdapter)this._memoryFiles.get(string);
        if (memoryIoAdapter == null) {
            return null;
        }
        return memoryIoAdapter._bytes;
    }

    public void growBy(int n) {
        if (n < 1) {
            n = 1;
        }
        this._growBy = n;
    }

    public void close() throws IOException {
    }

    public void delete(String string) {
        this._memoryFiles.remove(string);
    }

    public boolean exists(String string) {
        MemoryIoAdapter memoryIoAdapter = (MemoryIoAdapter)this._memoryFiles.get(string);
        if (memoryIoAdapter == null) {
            return false;
        }
        return memoryIoAdapter._length > 0;
    }

    public long getLength() throws IOException {
        return this._length;
    }

    public IoAdapter open(String string, boolean bl, long l) throws IOException {
        MemoryIoAdapter memoryIoAdapter = (MemoryIoAdapter)this._memoryFiles.get(string);
        if (memoryIoAdapter == null) {
            memoryIoAdapter = new MemoryIoAdapter(this, string, (int)l);
            this._memoryFiles.put(string, (Object)memoryIoAdapter);
        }
        return memoryIoAdapter;
    }

    public int read(byte[] byArray, int n) throws IOException {
        System.arraycopy(this._bytes, this._seekPos, byArray, 0, n);
        this._seekPos += n;
        return n;
    }

    public void seek(long l) throws IOException {
        this._seekPos = (int)l;
    }

    public void sync() throws IOException {
    }

    public void write(byte[] byArray, int n) throws IOException {
        if (this._seekPos + n > this._bytes.length) {
            int n2 = this._growBy;
            if (this._seekPos + n > n2) {
                n2 = this._seekPos + n;
            }
            byte[] byArray2 = new byte[this._bytes.length + n2];
            System.arraycopy(this._bytes, 0, byArray2, 0, this._length);
            this._bytes = byArray2;
        }
        System.arraycopy(byArray, 0, this._bytes, this._seekPos, n);
        this._seekPos += n;
        if (this._seekPos > this._length) {
            this._length = this._seekPos;
        }
    }
}

