/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.inside.marshall;

import com.db4o.CorruptionException;
import com.db4o.Transaction;
import com.db4o.YapReader;
import com.db4o.YapStream;
import com.db4o.YapWriter;
import com.db4o.inside.marshall.ObjectHeaderAttributes;

public abstract class StringMarshaller {
    public abstract boolean inlinedStrings();

    public abstract void calculateLengths(Transaction var1, ObjectHeaderAttributes var2, boolean var3, Object var4, boolean var5);

    protected final int linkLength() {
        return 8;
    }

    public abstract Object writeNew(Object var1, boolean var2, YapWriter var3, boolean var4);

    public final String read(YapStream yapStream, YapReader yapReader) throws CorruptionException {
        if (yapReader == null) {
            return null;
        }
        String string = StringMarshaller.readShort(yapStream, yapReader);
        return string;
    }

    public String readFromOwnSlot(YapStream yapStream, YapReader yapReader) {
        try {
            return this.read(yapStream, yapReader);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String readFromParentSlot(YapStream yapStream, YapReader yapReader, boolean bl) throws CorruptionException {
        if (!bl) {
            return this.read(yapStream, yapReader);
        }
        return this.read(yapStream, this.readSlotFromParentSlot(yapStream, yapReader));
    }

    public abstract YapWriter readIndexEntry(YapWriter var1) throws CorruptionException;

    public static String readShort(YapStream yapStream, YapReader yapReader) throws CorruptionException {
        int n = yapReader.readInt();
        if (n > 70000000) {
            throw new CorruptionException();
        }
        if (n > 0) {
            String string = yapStream.stringIO().read(yapReader, n);
            if (yapStream.i_config.internStrings()) {
                string = string.intern();
            }
            return string;
        }
        return "";
    }

    public abstract YapReader readSlotFromParentSlot(YapStream var1, YapReader var2) throws CorruptionException;

    public static YapReader writeShort(YapStream yapStream, String string) {
        YapReader yapReader = new YapReader(yapStream.stringIO().length(string));
        StringMarshaller.writeShort(yapStream, string, yapReader);
        return yapReader;
    }

    public static void writeShort(YapStream yapStream, String string, YapReader yapReader) {
        int n = string.length();
        yapReader.writeInt(n);
        yapStream.stringIO().write(yapReader, string);
    }
}

