/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.inside.ix;

import com.db4o.Tree;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Visitor4;
import com.db4o.foundation.Visitor4Dispatch;
import com.db4o.inside.ix.NIxPath;
import com.db4o.inside.ix.NIxPathNode;

public class NIxPaths {
    Tree _paths;

    void add(NIxPath nIxPath) {
        nIxPath._size = 1;
        nIxPath._preceding = null;
        nIxPath._subsequent = null;
        this._paths = Tree.add(this._paths, nIxPath);
    }

    void removeRedundancies() {
        final Collection4 collection4 = new Collection4();
        final boolean[] blArray = new boolean[]{false};
        this._paths.traverse(new Visitor4(){

            public void visit(Object object) {
                if (!blArray[0]) {
                    NIxPath nIxPath = (NIxPath)object;
                    if (!nIxPath._takePreceding) {
                        collection4.clear();
                    }
                    collection4.add(nIxPath);
                    if (!nIxPath._takeSubsequent) {
                        blArray[0] = true;
                    }
                }
            }
        });
        this._paths = null;
        Iterator4 iterator4 = collection4.iterator();
        while (iterator4.hasNext()) {
            this.add((NIxPath)iterator4.next());
        }
    }

    int count() {
        final NIxPath[] nIxPathArray = new NIxPath[]{null};
        final int[] nArray = new int[]{0};
        this._paths.traverse(new Visitor4(){

            public void visit(Object object) {
                NIxPath nIxPath = (NIxPath)object;
                if (nIxPathArray[0] == null) {
                    if (nIxPath._takePreceding) {
                        nArray[0] = nArray[0] + NIxPaths.this.countAllPreceding(nIxPath._head);
                    }
                } else if ((nIxPathArray[0]._takeSubsequent || nIxPathArray[0]._takeMatches) && (nIxPath._takePreceding || nIxPath._takeMatches)) {
                    nArray[0] = nArray[0] + NIxPaths.this.countSpan(nIxPath, nIxPathArray[0], nIxPath._head, nIxPathArray[0]._head, nIxPath._head._next, nIxPathArray[0]._head._next, 0);
                } else if (nIxPathArray[0]._takeMatches) {
                    nArray[0] = nArray[0] + NIxPaths.this.countAllMatching(nIxPathArray[0]._head);
                }
                nIxPathArray[0] = nIxPath;
            }
        });
        if (nIxPathArray[0]._takeMatches) {
            nArray[0] = nArray[0] + this.countAllMatching(nIxPathArray[0]._head);
        }
        if (nIxPathArray[0]._takeSubsequent) {
            nArray[0] = nArray[0] + this.countAllSubsequent(nIxPathArray[0]._head);
        }
        return nArray[0];
    }

    private int countAllPreceding(NIxPathNode nIxPathNode) {
        int n = 0;
        while (nIxPathNode != null) {
            n += nIxPathNode.countPreceding();
            nIxPathNode = nIxPathNode._next;
        }
        return n;
    }

    private int countAllMatching(NIxPathNode nIxPathNode) {
        int n = 0;
        while (nIxPathNode != null) {
            n += nIxPathNode.countMatching();
            nIxPathNode = nIxPathNode._next;
        }
        return n;
    }

    private int countAllSubsequent(NIxPathNode nIxPathNode) {
        int n = 0;
        while (nIxPathNode != null) {
            n += nIxPathNode.countSubsequent();
            nIxPathNode = nIxPathNode._next;
        }
        return n;
    }

    private int countSpan(NIxPath nIxPath, NIxPath nIxPath2, NIxPathNode nIxPathNode, NIxPathNode nIxPathNode2, NIxPathNode nIxPathNode3, NIxPathNode nIxPathNode4, int n) {
        n += nIxPathNode.countSpan(nIxPath, nIxPath2, nIxPathNode2);
        if (nIxPathNode3 != null && nIxPathNode3.carriesTheSame(nIxPathNode4)) {
            return this.countSpan(nIxPath, nIxPath2, nIxPathNode3, nIxPathNode4, nIxPathNode3._next, nIxPathNode4._next, n);
        }
        return n + this.countGreater(nIxPathNode4, 0) + this.countSmaller(nIxPathNode3, 0);
    }

    private int countSmaller(NIxPathNode nIxPathNode, int n) {
        if (nIxPathNode == null) {
            return n;
        }
        if (nIxPathNode._next == null) {
            return n + this.countPreceding(nIxPathNode);
        }
        n = nIxPathNode._next._tree == nIxPathNode._tree._subsequent ? (n += this.countPreceding(nIxPathNode)) : (n += nIxPathNode.countMatching());
        return this.countSmaller(nIxPathNode._next, n);
    }

    private int countGreater(NIxPathNode nIxPathNode, int n) {
        if (nIxPathNode == null) {
            return n;
        }
        if (nIxPathNode._next == null) {
            return n + this.countSubsequent(nIxPathNode);
        }
        n = nIxPathNode._next._tree == nIxPathNode._tree._preceding ? (n += this.countSubsequent(nIxPathNode)) : (n += nIxPathNode.countMatching());
        return this.countGreater(nIxPathNode._next, n);
    }

    private int countPreceding(NIxPathNode nIxPathNode) {
        return Tree.size(nIxPathNode._tree._preceding) + nIxPathNode.countMatching();
    }

    private int countSubsequent(NIxPathNode nIxPathNode) {
        return Tree.size(nIxPathNode._tree._subsequent) + nIxPathNode.countMatching();
    }

    void traverse(Visitor4 visitor4) {
        final NIxPath[] nIxPathArray = new NIxPath[]{null};
        final Visitor4Dispatch visitor4Dispatch = new Visitor4Dispatch(visitor4);
        this._paths.traverse(new Visitor4(){

            public void visit(Object object) {
                NIxPath nIxPath = (NIxPath)object;
                if (nIxPathArray[0] == null) {
                    if (nIxPath._takePreceding) {
                        NIxPaths.this.traverseAllPreceding(nIxPath._head, visitor4Dispatch);
                    }
                } else if ((nIxPathArray[0]._takeSubsequent || nIxPathArray[0]._takeMatches) && (nIxPath._takePreceding || nIxPath._takeMatches)) {
                    NIxPaths.this.traverseSpan(nIxPath, nIxPathArray[0], nIxPath._head, nIxPathArray[0]._head, nIxPath._head._next, nIxPathArray[0]._head._next, visitor4Dispatch);
                } else if (nIxPathArray[0]._takeMatches) {
                    NIxPaths.this.traverseAllMatching(nIxPathArray[0]._head, visitor4Dispatch);
                }
                nIxPathArray[0] = nIxPath;
            }
        });
        if (nIxPathArray[0]._takeMatches) {
            this.traverseAllMatching(nIxPathArray[0]._head, visitor4Dispatch);
        }
        if (nIxPathArray[0]._takeSubsequent) {
            this.traverseAllSubsequent(nIxPathArray[0]._head, visitor4Dispatch);
        }
    }

    private void traverseAllPreceding(NIxPathNode nIxPathNode, Visitor4Dispatch visitor4Dispatch) {
        while (nIxPathNode != null) {
            nIxPathNode.traversePreceding(visitor4Dispatch);
            nIxPathNode = nIxPathNode._next;
        }
    }

    private void traverseAllMatching(NIxPathNode nIxPathNode, Visitor4Dispatch visitor4Dispatch) {
        while (nIxPathNode != null) {
            nIxPathNode.traverseMatching(visitor4Dispatch);
            nIxPathNode = nIxPathNode._next;
        }
    }

    private void traverseAllSubsequent(NIxPathNode nIxPathNode, Visitor4Dispatch visitor4Dispatch) {
        while (nIxPathNode != null) {
            nIxPathNode.traverseSubsequent(visitor4Dispatch);
            nIxPathNode = nIxPathNode._next;
        }
    }

    private void traverseSpan(NIxPath nIxPath, NIxPath nIxPath2, NIxPathNode nIxPathNode, NIxPathNode nIxPathNode2, NIxPathNode nIxPathNode3, NIxPathNode nIxPathNode4, Visitor4Dispatch visitor4Dispatch) {
        nIxPathNode.traverseSpan(nIxPath, nIxPath2, nIxPathNode2, visitor4Dispatch);
        if (nIxPathNode3 != null && nIxPathNode3.carriesTheSame(nIxPathNode4)) {
            this.traverseSpan(nIxPath, nIxPath2, nIxPathNode3, nIxPathNode4, nIxPathNode3._next, nIxPathNode4._next, visitor4Dispatch);
            return;
        }
        this.traverseGreater(nIxPathNode4, visitor4Dispatch);
        this.traverseSmaller(nIxPathNode3, visitor4Dispatch);
    }

    private void traverseSmaller(NIxPathNode nIxPathNode, Visitor4Dispatch visitor4Dispatch) {
        if (nIxPathNode == null) {
            return;
        }
        if (nIxPathNode._next == null) {
            this.traversePreceding(nIxPathNode, visitor4Dispatch);
            return;
        }
        if (nIxPathNode._next._tree == nIxPathNode._tree._subsequent) {
            this.traversePreceding(nIxPathNode, visitor4Dispatch);
        } else {
            nIxPathNode.traverseMatching(visitor4Dispatch);
        }
        this.traverseSmaller(nIxPathNode._next, visitor4Dispatch);
    }

    private void traverseGreater(NIxPathNode nIxPathNode, Visitor4Dispatch visitor4Dispatch) {
        if (nIxPathNode == null) {
            return;
        }
        if (nIxPathNode._next == null) {
            this.traverseSubsequent(nIxPathNode, visitor4Dispatch);
            return;
        }
        if (nIxPathNode._next._tree == nIxPathNode._tree._preceding) {
            this.traverseSubsequent(nIxPathNode, visitor4Dispatch);
        } else {
            nIxPathNode.traverseMatching(visitor4Dispatch);
        }
        this.traverseGreater(nIxPathNode._next, visitor4Dispatch);
    }

    private void traversePreceding(NIxPathNode nIxPathNode, Visitor4Dispatch visitor4Dispatch) {
        nIxPathNode.traverseMatching(visitor4Dispatch);
        Tree.traverse(nIxPathNode._tree._preceding, visitor4Dispatch);
    }

    private void traverseSubsequent(NIxPathNode nIxPathNode, Visitor4Dispatch visitor4Dispatch) {
        nIxPathNode.traverseMatching(visitor4Dispatch);
        Tree.traverse(nIxPathNode._tree._subsequent, visitor4Dispatch);
    }
}

