/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.inside.ix;

import com.db4o.Transaction;
import com.db4o.Tree;
import com.db4o.foundation.Queue4;
import com.db4o.foundation.Visitor4;
import com.db4o.inside.ix.Index4;
import com.db4o.inside.ix.IxAdd;
import com.db4o.inside.ix.IxPatch;
import com.db4o.inside.ix.IxRemove;

public class IndexTransaction
implements Visitor4 {
    final Index4 i_index;
    final Transaction i_trans;
    int i_version;
    private Tree i_root;

    IndexTransaction(Transaction transaction, Index4 index4) {
        this.i_trans = transaction;
        this.i_index = index4;
    }

    public boolean equals(Object object) {
        return this.i_trans == ((IndexTransaction)object).i_trans;
    }

    public void add(int n, Object object) {
        this.patch(new IxAdd(this, n, object));
    }

    public void remove(int n, Object object) {
        this.patch(new IxRemove(this, n, object));
    }

    private void patch(IxPatch ixPatch) {
        this.i_root = Tree.add(this.i_root, ixPatch);
    }

    public Tree getRoot() {
        return this.i_root;
    }

    public void commit() {
        this.i_index.commit(this);
    }

    public void rollback() {
        this.i_index.rollback(this);
    }

    void merge(IndexTransaction indexTransaction) {
        Tree tree = indexTransaction.getRoot();
        if (tree != null) {
            tree.traverseFromLeaves(this);
        }
    }

    public void visit(Object object) {
        if (object instanceof IxPatch) {
            IxPatch ixPatch = (IxPatch)object;
            if (ixPatch.hasQueue()) {
                Queue4 queue4 = ixPatch.detachQueue();
                while ((ixPatch = (IxPatch)queue4.next()) != null) {
                    ixPatch.detachQueue();
                    this.addPatchToRoot(ixPatch);
                }
            } else {
                this.addPatchToRoot(ixPatch);
            }
        }
    }

    private void addPatchToRoot(IxPatch ixPatch) {
        if (ixPatch._version != this.i_version) {
            ixPatch.beginMerge();
            ixPatch.handler().prepareComparison(ixPatch.handler().comparableObject(this.i_trans, ixPatch._value));
            this.i_root = this.i_root == null ? ixPatch : this.i_root.add(ixPatch);
        }
    }

    int countLeaves() {
        if (this.i_root == null) {
            return 0;
        }
        final int[] nArray = new int[]{0};
        this.i_root.traverse(new Visitor4(){

            public void visit(Object object) {
                nArray[0] = nArray[0] + 1;
            }
        });
        return nArray[0];
    }

    public void setRoot(Tree tree) {
        this.i_root = tree;
    }

    public String toString() {
        return super.toString();
    }
}

