/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.inside.diagnostic;

import com.db4o.YapClass;
import com.db4o.YapField;
import com.db4o.diagnostic.ClassHasNoFields;
import com.db4o.diagnostic.Diagnostic;
import com.db4o.diagnostic.DiagnosticConfiguration;
import com.db4o.diagnostic.DiagnosticListener;
import com.db4o.diagnostic.LoadedFromClassIndex;
import com.db4o.diagnostic.NativeQueryNotOptimized;
import com.db4o.diagnostic.UpdateDepthGreaterOne;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.DeepClone;
import com.db4o.foundation.Iterator4;
import com.db4o.query.Predicate;

public class DiagnosticProcessor
implements DiagnosticConfiguration,
DeepClone {
    private Collection4 _listeners;

    public DiagnosticProcessor() {
    }

    private DiagnosticProcessor(Collection4 collection4) {
        this._listeners = collection4;
    }

    public void addListener(DiagnosticListener diagnosticListener) {
        if (this._listeners == null) {
            this._listeners = new Collection4();
        }
        this._listeners.add(diagnosticListener);
    }

    public void checkClassHasFields(YapClass yapClass) {
        YapField[] yapFieldArray = yapClass.i_fields;
        if (yapFieldArray != null && yapFieldArray.length == 0) {
            String string = yapClass.getName();
            String[] stringArray = new String[]{"java.util."};
            for (int i = 0; i < stringArray.length; ++i) {
                if (string.indexOf(stringArray[i]) != 0) continue;
                return;
            }
            if (this.isDb4oClass(yapClass)) {
                return;
            }
            this.onDiagnostic(new ClassHasNoFields(string));
        }
    }

    public void checkUpdateDepth(int n) {
        if (n > 1) {
            this.onDiagnostic(new UpdateDepthGreaterOne(n));
        }
    }

    public Object deepClone(Object object) {
        return this._listeners != null ? new DiagnosticProcessor(new Collection4(this._listeners)) : new DiagnosticProcessor();
    }

    public boolean enabled() {
        return this._listeners != null;
    }

    private boolean isDb4oClass(YapClass yapClass) {
        String string = yapClass.getName();
        if (string.indexOf("com.db4o.test") == 0) {
            return false;
        }
        return string.indexOf("com.db4o.") == 0;
    }

    public void loadedFromClassIndex(YapClass yapClass) {
        if (this.isDb4oClass(yapClass)) {
            return;
        }
        this.onDiagnostic(new LoadedFromClassIndex(yapClass.getName()));
    }

    public void nativeQueryUnoptimized(Predicate predicate) {
        this.onDiagnostic(new NativeQueryNotOptimized(predicate));
    }

    private void onDiagnostic(Diagnostic diagnostic) {
        if (this._listeners == null) {
            return;
        }
        Iterator4 iterator4 = this._listeners.iterator();
        while (iterator4.hasNext()) {
            ((DiagnosticListener)iterator4.next()).onDiagnostic(diagnostic);
        }
    }

    public void removeAllListeners() {
        this._listeners = null;
    }
}

