/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.inside.cluster;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.cluster.Cluster;
import com.db4o.inside.Exceptions4;
import com.db4o.inside.query.ObjectSetFacade;
import com.db4o.inside.query.QueryResult;
import com.db4o.query.Query;
import com.db4o.query.QueryComparator;

public class ClusterQueryResult
implements QueryResult {
    private final Cluster _cluster;
    private final ObjectSet[] _objectSets;
    private int _current;
    private final int[] _sizes;
    private final int _size;

    public ClusterQueryResult(Cluster cluster, Query[] queryArray) {
        this._cluster = cluster;
        this._objectSets = new ObjectSet[queryArray.length];
        this._sizes = new int[queryArray.length];
        int n = 0;
        for (int i = 0; i < queryArray.length; ++i) {
            this._objectSets[i] = queryArray[i].execute();
            this._sizes[i] = this._objectSets[i].size();
            n += this._sizes[i];
        }
        this._size = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() {
        Cluster cluster = this._cluster;
        synchronized (cluster) {
            return this.hasNextNoSync();
        }
    }

    private ObjectSet current() {
        return this._objectSets[this._current];
    }

    private boolean hasNextNoSync() {
        if (this.current().hasNext()) {
            return true;
        }
        if (this._current >= this._objectSets.length - 1) {
            return false;
        }
        ++this._current;
        return this.hasNextNoSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object next() {
        Cluster cluster = this._cluster;
        synchronized (cluster) {
            if (this.hasNextNoSync()) {
                return this.current().next();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Cluster cluster = this._cluster;
        synchronized (cluster) {
            for (int i = 0; i < this._objectSets.length; ++i) {
                this._objectSets[i].reset();
            }
            this._current = 0;
        }
    }

    public int size() {
        return this._size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int n) {
        Cluster cluster = this._cluster;
        synchronized (cluster) {
            if (n < 0 || n >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            int n2 = 0;
            while (n >= this._sizes[n2]) {
                n -= this._sizes[n2];
                ++n2;
            }
            return ((ObjectSetFacade)this._objectSets[n2])._delegate.get(n);
        }
    }

    public long[] getIDs() {
        Exceptions4.notSupported();
        return null;
    }

    public Object streamLock() {
        return this._cluster;
    }

    public ObjectContainer objectContainer() {
        return this._cluster._objectContainers[this._current];
    }

    public int indexOf(int n) {
        Exceptions4.notSupported();
        return 0;
    }

    public void sort(QueryComparator queryComparator) {
        Exceptions4.notSupported();
    }
}

