/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.inside.btree;

import com.db4o.Null;
import com.db4o.Transaction;
import com.db4o.Tree;
import com.db4o.TreeInt;
import com.db4o.TreeIntObject;
import com.db4o.YapMeta;
import com.db4o.YapReader;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Queue4;
import com.db4o.foundation.Visitor4;
import com.db4o.inside.btree.BTreeNode;
import com.db4o.inside.ix.Indexable4;

public class BTree
extends YapMeta {
    private static final byte BTREE_VERSION = 1;
    final Indexable4 _keyHandler;
    final Indexable4 _valueHandler;
    private BTreeNode _root;
    private TreeIntObject _nodes;
    private int _size;
    private Visitor4 _removeListener;
    private Hashtable4 _sizesByTransaction;
    private Queue4 _processing;
    int _nodeSize;
    int _halfNodeSize;
    private final int _cacheHeight;

    public BTree(int n, int n2, Transaction transaction, int n3, Indexable4 indexable4, Indexable4 indexable42) {
        this._halfNodeSize = n / 2;
        this._nodeSize = this._halfNodeSize * 2;
        this._cacheHeight = n2;
        this._keyHandler = indexable4;
        this._valueHandler = indexable42 == null ? Null.INSTANCE : indexable42;
        this._sizesByTransaction = new Hashtable4(1);
        if (n3 == 0) {
            this.setStateDirty();
            this._root = new BTreeNode(this, 0, true, 0, 0, 0);
            this._root.write(transaction.systemTransaction());
            this.addNode(this._root);
            this.write(transaction.systemTransaction());
        } else {
            this.setID(n3);
            this.setStateDeactivated();
        }
    }

    public void add(Transaction transaction, Object object) {
        this.ensureDirty(transaction);
        this._keyHandler.prepareComparison(object);
        BTreeNode bTreeNode = this._root.add(transaction);
        if (bTreeNode != null && bTreeNode != this._root) {
            this._root = new BTreeNode(transaction, this._root, bTreeNode);
            this._root.write(transaction.systemTransaction());
            this.addNode(this._root);
        }
        this.setStateDirty();
        this.sizeChanged(transaction, 1);
    }

    public void remove(Transaction transaction, Object object) {
        this.ensureDirty(transaction);
        this._keyHandler.prepareComparison(object);
        this._root.remove(transaction);
        this.sizeChanged(transaction, -1);
    }

    public void commit(Transaction transaction) {
        final Transaction transaction2 = transaction.systemTransaction();
        Object object = this._sizesByTransaction.get(transaction);
        if (object != null) {
            this._size += ((Integer)object).intValue();
        }
        this._sizesByTransaction.remove(transaction);
        if (this._nodes != null) {
            this.processAllNodes();
            while (this._processing.hasNext()) {
                ((BTreeNode)this._processing.next()).commit(transaction);
            }
            this._processing = null;
            if (this._nodes != null) {
                this._nodes.traverse(new Visitor4(){

                    public void visit(Object object) {
                        BTreeNode bTreeNode = (BTreeNode)((TreeIntObject)object).getObject();
                        bTreeNode.setStateDirty();
                        bTreeNode.write(transaction2);
                    }
                });
            }
        }
        this.setStateDirty();
        this.write(transaction2);
        this.purge();
    }

    public void rollback(Transaction transaction) {
        this._sizesByTransaction.remove(transaction);
        if (this._nodes == null) {
            return;
        }
        this.processAllNodes();
        while (this._processing.hasNext()) {
            ((BTreeNode)this._processing.next()).rollback(transaction);
        }
        this._processing = null;
        this.purge();
    }

    private void purge() {
        if (this._nodes == null) {
            return;
        }
        TreeIntObject treeIntObject = this._nodes;
        this._nodes = null;
        if (this._cacheHeight > 0) {
            this._root.markAsCached(this._cacheHeight);
        } else {
            this._root.holdChildrenAsIDs();
            this.addNode(this._root);
        }
        treeIntObject.traverse(new Visitor4(){

            public void visit(Object object) {
                BTreeNode bTreeNode = (BTreeNode)((TreeIntObject)object).getObject();
                bTreeNode.purge();
            }
        });
    }

    private void processAllNodes() {
        this._processing = new Queue4();
        this._nodes.traverse(new Visitor4(){

            public void visit(Object object) {
                BTree.this._processing.add(((TreeIntObject)object).getObject());
            }
        });
    }

    private void ensureActive(Transaction transaction) {
        if (!this.isActive()) {
            this.read(transaction.systemTransaction());
        }
    }

    private void ensureDirty(Transaction transaction) {
        this.ensureActive(transaction);
        transaction.dirtyBTree(this);
        this.setStateDirty();
    }

    public byte getIdentifier() {
        return 84;
    }

    public void setRemoveListener(Visitor4 visitor4) {
        this._removeListener = visitor4;
    }

    public int ownLength() {
        return 13;
    }

    BTreeNode produceNode(int n) {
        TreeIntObject treeIntObject = new TreeIntObject(n);
        this._nodes = (TreeIntObject)Tree.add(this._nodes, treeIntObject);
        TreeIntObject treeIntObject2 = (TreeIntObject)treeIntObject.duplicateOrThis();
        BTreeNode bTreeNode = (BTreeNode)treeIntObject2.getObject();
        if (bTreeNode == null) {
            bTreeNode = new BTreeNode(n, this);
            treeIntObject2.setObject(bTreeNode);
            this.addToProcessing(bTreeNode);
        }
        return bTreeNode;
    }

    void addNode(BTreeNode bTreeNode) {
        this._nodes = (TreeIntObject)Tree.add(this._nodes, new TreeIntObject(bTreeNode.getID(), bTreeNode));
        this.addToProcessing(bTreeNode);
    }

    void addToProcessing(BTreeNode bTreeNode) {
        if (this._processing != null) {
            this._processing.add(bTreeNode);
        }
    }

    void removeNode(BTreeNode bTreeNode) {
        this._nodes = (TreeIntObject)this._nodes.removeLike(new TreeInt(bTreeNode.getID()));
    }

    void notifyRemoveListener(Object object) {
        if (this._removeListener != null) {
            this._removeListener.visit(object);
        }
    }

    public void readThis(Transaction transaction, YapReader yapReader) {
        yapReader.incrementOffset(1);
        this._size = yapReader.readInt();
        this._nodeSize = yapReader.readInt();
        this._halfNodeSize = this._nodeSize / 2;
        this._root = this.produceNode(yapReader.readInt());
    }

    public void writeThis(Transaction transaction, YapReader yapReader) {
        yapReader.append((byte)1);
        yapReader.writeInt(this._size);
        yapReader.writeInt(this._nodeSize);
        yapReader.writeIDOf(transaction, this._root);
    }

    public int size(Transaction transaction) {
        this.ensureActive(transaction);
        Object object = this._sizesByTransaction.get(transaction);
        if (object != null) {
            return this._size + (Integer)object;
        }
        return this._size;
    }

    public void traverseKeys(Transaction transaction, Visitor4 visitor4) {
        this.ensureActive(transaction);
        if (this._root == null) {
            return;
        }
        this._root.traverseKeys(transaction, visitor4);
    }

    private void sizeChanged(Transaction transaction, int n) {
        Object object = this._sizesByTransaction.get(transaction);
        if (object == null) {
            this._sizesByTransaction.put(transaction, (Object)new Integer(n));
            return;
        }
        this._sizesByTransaction.put(transaction, (Object)new Integer((Integer)object + n));
    }
}

