/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.ClassIndex;
import com.db4o.PBootRecord;
import com.db4o.QueryResultImpl;
import com.db4o.Transaction;
import com.db4o.Tree;
import com.db4o.TreeInt;
import com.db4o.TreeIntObject;
import com.db4o.UseSystemTransaction;
import com.db4o.YInt;
import com.db4o.YapClass;
import com.db4o.YapClassCollectionIterator;
import com.db4o.YapConfigBlock;
import com.db4o.YapConst;
import com.db4o.YapMeta;
import com.db4o.YapObject;
import com.db4o.YapReader;
import com.db4o.YapStream;
import com.db4o.YapWriter;
import com.db4o.ext.Db4oDatabase;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Visitor4;
import com.db4o.inside.Exceptions4;
import com.db4o.inside.btree.BTree;
import com.db4o.inside.convert.Converter;
import com.db4o.inside.freespace.FreespaceManager;
import com.db4o.inside.slots.Pointer4;
import com.db4o.inside.slots.ReferencedSlot;
import com.db4o.inside.slots.Slot;
import com.db4o.reflect.ReflectClass;
import java.io.IOException;

public abstract class YapFile
extends YapStream {
    protected YapConfigBlock _configBlock;
    private PBootRecord _bootRecord;
    private Collection4 i_dirty;
    private FreespaceManager _freespaceManager;
    private FreespaceManager _fmChecker;
    private boolean i_isServer = false;
    private Tree i_prefetchedIDs;
    private Hashtable4 i_semaphores;
    int i_writeAt;
    private Tree _freeOnCommit;

    YapFile(YapStream yapStream) {
        super(yapStream);
    }

    void blockSize(int n) {
    }

    public PBootRecord bootRecord() {
        return this._bootRecord;
    }

    boolean close2() {
        boolean bl = super.close2();
        this.i_dirty = null;
        return bl;
    }

    void commit1() {
        this.checkClosed();
        ++this.i_entryCounter;
        try {
            this.write(false);
        }
        catch (Throwable throwable) {
            this.fatalException(throwable);
        }
        --this.i_entryCounter;
    }

    void configureNewFile() {
        this._freespaceManager = FreespaceManager.createNew(this, this.i_config.freespaceSystem());
        this.blockSize(this.i_config.blockSize());
        this.i_writeAt = this.blocksFor(18L);
        this._configBlock = new YapConfigBlock(this);
        this._configBlock.converterVersion(5);
        this._configBlock.write();
        this._configBlock.go();
        this.initNewClassCollection();
        this.initializeEssentialClasses();
        this.initBootRecord();
        this._freespaceManager.start(this._configBlock._freespaceAddress);
    }

    long currentVersion() {
        return this._bootRecord.currentVersion();
    }

    void initNewClassCollection() {
        this.i_classCollection.initTables(1);
    }

    final ClassIndex createClassIndex(YapClass yapClass) {
        return new ClassIndex(yapClass);
    }

    final BTree createBTreeClassIndex(YapClass yapClass, int n) {
        return new BTree(this.i_config.bTreeNodeSize(), this.i_config.bTreeCacheHeight(), this.i_trans, n, new YInt(this), null);
    }

    final QueryResultImpl createQResult(Transaction transaction) {
        return new QueryResultImpl(transaction);
    }

    final boolean delete5(Transaction transaction, YapObject yapObject, int n, boolean bl) {
        int n2 = yapObject.getID();
        YapWriter yapWriter = this.readWriterByID(transaction, n2);
        if (yapWriter != null) {
            Object object = yapObject.getObject();
            if (object != null && !this.showInternalClasses() && YapConst.CLASS_INTERNAL.isAssignableFrom(object.getClass())) {
                return false;
            }
            yapWriter.setCascadeDeletes(n);
            yapWriter.slotDelete();
            YapClass yapClass = yapObject.getYapClass();
            yapClass.delete(yapWriter, object);
            return true;
        }
        return false;
    }

    abstract long fileLength();

    abstract String fileName();

    public void free(Slot slot) {
        if (slot == null) {
            return;
        }
        if (slot._address == 0) {
            return;
        }
        this.free(slot._address, slot._length);
    }

    public void free(int n, int n2) {
        this._freespaceManager.free(n, n2);
    }

    final void freePrefetchedPointers() {
        if (this.i_prefetchedIDs != null) {
            this.i_prefetchedIDs.traverse(new Visitor4(){

                public void visit(Object object) {
                    YapFile.this.free(((TreeInt)object)._key, 8);
                }
            });
        }
        this.i_prefetchedIDs = null;
    }

    final void freeSpaceBeginCommit() {
        if (this._freespaceManager == null) {
            return;
        }
        this._freespaceManager.beginCommit();
    }

    final void freeSpaceEndCommit() {
        if (this._freespaceManager == null) {
            return;
        }
        this._freespaceManager.endCommit();
    }

    void getAll(Transaction transaction, final QueryResultImpl queryResultImpl) {
        final Tree[] treeArray = new Tree[1];
        YapClassCollectionIterator yapClassCollectionIterator = this.i_classCollection.iterator();
        while (yapClassCollectionIterator.hasNext()) {
            BTree bTree;
            ReflectClass reflectClass;
            YapClass yapClass = yapClassCollectionIterator.readNextClass();
            if (yapClass.getName() == null || (reflectClass = yapClass.classReflector()) != null && this.i_handlers.ICLASS_INTERNAL.isAssignableFrom(reflectClass) || (bTree = yapClass.index()) == null) continue;
            bTree.traverseKeys(transaction, new Visitor4(){

                public void visit(Object object) {
                    int n = (Integer)object;
                    TreeInt treeInt = new TreeInt(n);
                    treeArray[0] = Tree.add(treeArray[0], treeInt);
                    if (treeInt.size() != 0) {
                        queryResultImpl.add(n);
                    }
                }
            });
        }
        queryResultImpl.reset();
    }

    final int getPointerSlot() {
        int n = this.getSlot(8);
        this.i_systemTrans.writePointer(n, 0, 0);
        if (n <= this.i_handlers.maxTypeID()) {
            return this.getPointerSlot();
        }
        return n;
    }

    public int getSlot(int n) {
        return this.getSlot1(n);
    }

    private final int getSlot1(int n) {
        int n2;
        if (this._freespaceManager != null && (n2 = this._freespaceManager.getSlot(n)) > 0) {
            return n2;
        }
        n2 = this.blocksFor(n);
        int n3 = this.i_writeAt;
        this.i_writeAt += n2;
        return n3;
    }

    void ensureLastSlotWritten() {
        if (this.i_writeAt > this.blocksFor(this.fileLength())) {
            YapWriter yapWriter = this.getWriter(this.i_systemTrans, this.i_writeAt - 1, this.blockSize());
            yapWriter.write();
        }
    }

    public Db4oDatabase identity() {
        if (this._bootRecord == null) {
            return null;
        }
        return this._bootRecord.i_db;
    }

    void initialize2() {
        this.i_dirty = new Collection4();
        super.initialize2();
    }

    private void initBootRecord() {
        this.showInternalClasses(true);
        this._bootRecord = new PBootRecord();
        this._bootRecord.i_stream = this;
        this._bootRecord.init(this.i_config);
        this.setInternal(this.i_systemTrans, this._bootRecord, false);
        this._configBlock._bootRecordID = this.getID1(this.i_systemTrans, this._bootRecord);
        this._configBlock.write();
        this.showInternalClasses(false);
    }

    boolean isServer() {
        return this.i_isServer;
    }

    public final Pointer4 newSlot(Transaction transaction, int n) {
        int n2 = this.getPointerSlot();
        int n3 = this.getSlot(n);
        transaction.setPointer(n2, n3, n);
        return new Pointer4(n2, n3);
    }

    public final int newUserObject() {
        return this.getPointerSlot();
    }

    void prefetchedIDConsumed(int n) {
        this.i_prefetchedIDs = this.i_prefetchedIDs.removeLike(new TreeIntObject(n));
    }

    int prefetchID() {
        int n = this.getPointerSlot();
        this.i_prefetchedIDs = Tree.add(this.i_prefetchedIDs, new TreeInt(n));
        return n;
    }

    public ReferencedSlot produceFreeOnCommitEntry(int n) {
        TreeInt treeInt = TreeInt.find(this._freeOnCommit, n);
        if (treeInt != null) {
            return (ReferencedSlot)treeInt;
        }
        ReferencedSlot referencedSlot = new ReferencedSlot(n);
        this._freeOnCommit = Tree.add(this._freeOnCommit, referencedSlot);
        return referencedSlot;
    }

    public void reduceFreeOnCommitReferences(ReferencedSlot referencedSlot) {
        if (referencedSlot.removeReferenceIsLast()) {
            this._freeOnCommit = this._freeOnCommit.removeNode(referencedSlot);
        }
    }

    public void freeDuringCommit(ReferencedSlot referencedSlot, Slot slot) {
        this._freeOnCommit = referencedSlot.free(this, this._freeOnCommit, slot);
    }

    public void raiseVersion(long l) {
        this._bootRecord.raiseVersion(l);
    }

    public YapWriter readWriterByID(Transaction transaction, int n) {
        return (YapWriter)this.readReaderOrWriterByID(transaction, n, false);
    }

    public YapReader readReaderByID(Transaction transaction, int n) {
        return this.readReaderOrWriterByID(transaction, n, true);
    }

    private final YapReader readReaderOrWriterByID(Transaction transaction, int n, boolean bl) {
        if (n == 0) {
            return null;
        }
        try {
            Slot slot = transaction.getSlotInformation(n);
            if (slot == null) {
                return null;
            }
            if (slot._address == 0) {
                return null;
            }
            YapReader yapReader = null;
            if (bl) {
                yapReader = new YapReader(slot._length);
            } else {
                yapReader = this.getWriter(transaction, slot._address, slot._length);
                ((YapWriter)yapReader).setID(n);
            }
            yapReader.readEncrypt(this, slot._address);
            return yapReader;
        }
        catch (Exception exception) {
            return null;
        }
    }

    void readThis() {
        Object object;
        YapWriter yapWriter = this.getWriter(this.i_systemTrans, 0, 18);
        yapWriter.read();
        byte by = yapWriter.readByte();
        byte by2 = 1;
        if (by != 123) {
            if (by != 4) {
                Exceptions4.throwRuntimeException(17);
            }
            by2 = yapWriter.readByte();
        } else if (yapWriter.readByte() != 89) {
            Exceptions4.throwRuntimeException(17);
        }
        this.blockSize(by2);
        this.i_writeAt = this.blocksFor(this.fileLength());
        this._configBlock = new YapConfigBlock(this);
        this._configBlock.read(yapWriter.readInt());
        yapWriter.incrementOffset(4);
        this.i_classCollection.setID(yapWriter.readInt());
        this.i_classCollection.read(this.i_systemTrans);
        int n = yapWriter.readInt();
        this._freespaceManager = FreespaceManager.createNew(this, this._configBlock._freespaceSystem);
        this._freespaceManager.read(n);
        this._freespaceManager.start(this._configBlock._freespaceAddress);
        if ((this.i_config.freespaceSystem() != 0 || this._configBlock._freespaceSystem == 1) && this._freespaceManager.systemType() != this.i_config.freespaceSystem()) {
            object = FreespaceManager.createNew(this, this.i_config.freespaceSystem());
            int n2 = this._configBlock.newFreespaceSlot(this.i_config.freespaceSystem());
            ((FreespaceManager)object).start(n2);
            this._freespaceManager.migrate((FreespaceManager)object);
            FreespaceManager freespaceManager = this._freespaceManager;
            this._freespaceManager = object;
            freespaceManager.freeSelf();
            this._freespaceManager.beginCommit();
            this._freespaceManager.endCommit();
            this._configBlock.write();
        }
        this.showInternalClasses(true);
        object = null;
        if (this._configBlock._bootRecordID > 0) {
            object = this.getByID1(this.i_systemTrans, this._configBlock._bootRecordID);
        }
        if (object instanceof PBootRecord) {
            this._bootRecord = (PBootRecord)object;
            this._bootRecord.checkActive();
            this._bootRecord.i_stream = this;
            if (this._bootRecord.initConfig(this.i_config)) {
                this.i_classCollection.reReadYapClass(this.getYapClass(this.i_handlers.ICLASS_PBOOTRECORD, false));
                this.setInternal(this.i_systemTrans, this._bootRecord, false);
            }
        } else {
            this.initBootRecord();
        }
        this.showInternalClasses(false);
        this.writeHeader(false);
        Transaction transaction = this._configBlock.getTransactionToCommit();
        if (transaction != null && !this.i_config.commitRecoveryDisabled()) {
            transaction.writeOld();
        }
        if (Converter.convert(this, this._configBlock)) {
            this.getTransaction().commit();
        }
    }

    public void releaseSemaphore(String string) {
        this.releaseSemaphore(this.checkTransaction(null), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseSemaphore(Transaction transaction, String string) {
        if (this.i_semaphores != null) {
            Hashtable4 hashtable4 = this.i_semaphores;
            synchronized (hashtable4) {
                if (this.i_semaphores != null && transaction == this.i_semaphores.get(string)) {
                    this.i_semaphores.remove(string);
                    this.i_semaphores.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseSemaphores(Transaction transaction) {
        if (this.i_semaphores != null) {
            Hashtable4 hashtable4 = this.i_semaphores;
            synchronized (hashtable4) {
                this.i_semaphores.forEachKeyForIdentity(new Visitor4(){

                    public void visit(Object object) {
                        YapFile.this.i_semaphores.remove(object);
                    }
                }, transaction);
                this.i_semaphores.notifyAll();
            }
        }
    }

    final void rollback1() {
        this.checkClosed();
        ++this.i_entryCounter;
        this.getTransaction().rollback();
        --this.i_entryCounter;
    }

    final void setDirty(UseSystemTransaction useSystemTransaction) {
        ((YapMeta)((Object)useSystemTransaction)).setStateDirty();
        ((YapMeta)((Object)useSystemTransaction)).cacheDirty(this.i_dirty);
    }

    public boolean setSemaphore(String string, int n) {
        return this.setSemaphore(this.checkTransaction(null), string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setSemaphore(Transaction transaction, String string, int n) {
        Object object;
        if (string == null) {
            throw new NullPointerException();
        }
        if (this.i_semaphores == null) {
            object = this.i_lock;
            synchronized (object) {
                if (this.i_semaphores == null) {
                    this.i_semaphores = new Hashtable4(10);
                }
            }
        }
        object = this.i_semaphores;
        synchronized (object) {
            Object object2 = this.i_semaphores.get(string);
            if (object2 == null) {
                this.i_semaphores.put(string, (Object)transaction);
                return true;
            }
            if (transaction == object2) {
                return true;
            }
            long l = System.currentTimeMillis() + (long)n;
            long l2 = n;
            while (l2 > 0L) {
                try {
                    this.i_semaphores.wait(l2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.i_classCollection == null) {
                    return false;
                }
                object2 = this.i_semaphores.get(string);
                if (object2 == null) {
                    this.i_semaphores.put(string, (Object)transaction);
                    return true;
                }
                l2 = l - System.currentTimeMillis();
            }
            return false;
        }
    }

    void setServer(boolean bl) {
        this.i_isServer = bl;
    }

    public abstract void copy(int var1, int var2, int var3, int var4, int var5);

    public abstract void syncFiles();

    public String toString() {
        return this.fileName();
    }

    void write(boolean bl) {
        this.i_trans.commit();
        if (bl) {
            this.writeHeader(bl);
        }
    }

    abstract boolean writeAccessTime() throws IOException;

    abstract void writeBytes(YapReader var1, int var2, int var3);

    final void writeDirty() {
        Iterator4 iterator4 = this.i_dirty.iterator();
        while (iterator4.hasNext()) {
            YapMeta yapMeta = (YapMeta)iterator4.next();
            yapMeta.write(this.i_systemTrans);
            yapMeta.notCachedDirty();
        }
        this.i_dirty.clear();
        this.writeBootRecord();
    }

    public final void writeEmbedded(YapWriter yapWriter, YapWriter yapWriter2) {
        int n = yapWriter2.getLength();
        int n2 = this.getSlot(n);
        yapWriter2.getTransaction().slotFreeOnRollback(n2, n2, n);
        yapWriter2.address(n2);
        yapWriter2.writeEncrypt();
        int n3 = yapWriter._offset;
        yapWriter._offset = yapWriter2.getID();
        yapWriter.writeInt(n2);
        yapWriter._offset = n3;
    }

    void writeHeader(boolean bl) {
        int n = this._freespaceManager.write(bl);
        if (bl) {
            this._freespaceManager = null;
        }
        YapWriter yapWriter = this.getWriter(this.i_systemTrans, 0, 18);
        yapWriter.append((byte)4);
        yapWriter.append(this.blockSize());
        yapWriter.writeInt(this._configBlock._address);
        yapWriter.writeInt(0);
        yapWriter.writeInt(this.i_classCollection.getID());
        yapWriter.writeInt(n);
        yapWriter.write();
        if (bl) {
            this.ensureLastSlotWritten();
        }
        this.syncFiles();
    }

    public final void writeNew(YapClass yapClass, YapWriter yapWriter) {
        this.writeObject(null, yapWriter, yapWriter.getAddress());
        if (yapClass == null) {
            return;
        }
        if (this.maintainsIndices()) {
            yapClass.addToIndex(this, yapWriter.getTransaction(), yapWriter.getID());
        }
    }

    final void writeObject(YapMeta yapMeta, YapReader yapReader, int n) {
        this.i_handlers.encrypt(yapReader);
        this.writeBytes(yapReader, n, 0);
    }

    void writeBootRecord() {
        this._bootRecord.store(1);
    }

    public abstract void writeXBytes(int var1, int var2);

    YapWriter xBytes(int n, int n2) {
        throw Exceptions4.virtualException();
    }

    final void writeTransactionPointer(int n) {
        YapWriter yapWriter = new YapWriter(this.i_systemTrans, this._configBlock._address, 8);
        yapWriter.moveForward(21);
        yapWriter.writeInt(n);
        yapWriter.writeInt(n);
        yapWriter.write();
    }

    public final void getSlotForUpdate(YapWriter yapWriter) {
        Transaction transaction = yapWriter.getTransaction();
        int n = yapWriter.getID();
        int n2 = yapWriter.getLength();
        int n3 = this.getSlot(n2);
        yapWriter.address(n3);
        transaction.slotFreeOnRollbackSetPointer(n, n3, n2);
    }

    public final void writeUpdate(YapClass yapClass, YapWriter yapWriter) {
        if (yapWriter.getAddress() == 0) {
            this.getSlotForUpdate(yapWriter);
        }
        this.i_handlers.encrypt(yapWriter);
        yapWriter.write();
    }
}

