/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.DeleteInfo;
import com.db4o.Msg;
import com.db4o.MsgD;
import com.db4o.Transaction;
import com.db4o.Tree;
import com.db4o.TreeIntObject;
import com.db4o.YapClass;
import com.db4o.YapClient;
import com.db4o.YapObject;
import com.db4o.foundation.Visitor4;

final class TransactionClient
extends Transaction {
    private final YapClient i_client;
    private Tree i_yapObjectsToGc;

    TransactionClient(YapClient yapClient, Transaction transaction) {
        super(yapClient, transaction);
        this.i_client = yapClient;
    }

    void beginEndSet() {
        if (this.i_delete != null) {
            this.i_delete.traverse(new Visitor4(){

                public void visit(Object object) {
                    DeleteInfo deleteInfo = (DeleteInfo)object;
                    if (deleteInfo._delete && deleteInfo._reference != null) {
                        TransactionClient.this.i_yapObjectsToGc = Tree.add(TransactionClient.this.i_yapObjectsToGc, new TreeIntObject(deleteInfo._key, deleteInfo._reference));
                    }
                }
            });
        }
        this.i_delete = null;
        this.i_writtenUpdateDeletedMembers = null;
        this.i_client.writeMsg(Msg.TA_BEGIN_END_SET);
    }

    void commit() {
        this.commitTransactionListeners();
        if (this.i_yapObjectsToGc != null) {
            this.i_yapObjectsToGc.traverse(new Visitor4(){

                public void visit(Object object) {
                    YapObject yapObject = (YapObject)((TreeIntObject)object)._object;
                    TransactionClient.this.i_stream.yapObjectGCd(yapObject);
                }
            });
        }
        this.i_yapObjectsToGc = null;
        this.i_client.writeMsg(Msg.COMMIT);
    }

    void delete(YapObject yapObject, int n) {
        super.delete(yapObject, n);
        this.i_client.writeMsg(Msg.TA_DELETE.getWriterForInts(this, new int[]{yapObject.getID(), n}));
    }

    void dontDelete(int n, int n2) {
        super.dontDelete(n, n2);
        this.i_client.writeMsg(Msg.TA_DONT_DELETE.getWriterForInts(this, new int[]{n, n2}));
    }

    boolean isDeleted(int n) {
        this.i_client.writeMsg(Msg.TA_IS_DELETED.getWriterForInt(this, n));
        int n2 = this.i_client.expectedByteResponse(Msg.TA_IS_DELETED).readInt();
        return n2 == 1;
    }

    Object[] objectAndYapObjectBySignature(long l, byte[] byArray) {
        int n = 12 + byArray.length;
        MsgD msgD = Msg.OBJECT_BY_UUID.getWriterForLength(this, n);
        msgD.writeLong(l);
        msgD.writeBytes(byArray);
        this.i_client.writeMsg(msgD);
        msgD = (MsgD)this.i_client.expectedResponse(Msg.OBJECT_BY_UUID);
        int n2 = msgD.readInt();
        if (n2 > 0) {
            return this.i_stream.getObjectAndYapObjectByID(this, n2);
        }
        return new Object[2];
    }

    public void rollback() {
        this.i_yapObjectsToGc = null;
        this.rollBackTransactionListeners();
    }

    void writeUpdateDeleteMembers(int n, YapClass yapClass, int n2, int n3) {
        this.i_client.writeMsg(Msg.WRITE_UPDATE_DELETE_MEMBERS.getWriterForInts(this, new int[]{n, yapClass.getID(), n2, n3}));
    }
}

