/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.inside.marshall;

import com.db4o.Config4Class;
import com.db4o.CorruptionException;
import com.db4o.Db4oTypeImpl;
import com.db4o.Transaction;
import com.db4o.TreeInt;
import com.db4o.YapClass;
import com.db4o.YapClassPrimitive;
import com.db4o.YapField;
import com.db4o.YapObject;
import com.db4o.YapReader;
import com.db4o.YapWriter;
import com.db4o.inside.marshall.MarshallerFamily;
import com.db4o.inside.marshall.ObjectHeaderAttributes;
import com.db4o.inside.marshall.ObjectMarshaller;

class ObjectMarshaller0
extends ObjectMarshaller {
    ObjectMarshaller0() {
    }

    public void addFieldIndices(YapClass yapClass, ObjectHeaderAttributes objectHeaderAttributes, YapWriter yapWriter, boolean bl) {
        int n = yapWriter.readInt();
        for (int i = 0; i < n; ++i) {
            yapClass.i_fields[i].addFieldIndex(this._family, yapWriter, bl);
        }
        if (yapClass.i_ancestor != null) {
            this.addFieldIndices(yapClass.i_ancestor, objectHeaderAttributes, yapWriter, bl);
        }
    }

    public TreeInt collectFieldIDs(TreeInt treeInt, YapClass yapClass, ObjectHeaderAttributes objectHeaderAttributes, YapWriter yapWriter, String string) {
        int n = yapClass.readFieldCount(yapWriter);
        for (int i = 0; i < n; ++i) {
            if (string.equals(yapClass.i_fields[i].getName())) {
                treeInt = yapClass.i_fields[i].collectIDs(this._family, treeInt, yapWriter);
                continue;
            }
            yapClass.i_fields[i].incrementOffset(yapWriter);
        }
        if (yapClass.i_ancestor != null) {
            return this.collectFieldIDs(treeInt, yapClass.i_ancestor, objectHeaderAttributes, yapWriter, string);
        }
        return treeInt;
    }

    public void deleteMembers(YapClass yapClass, ObjectHeaderAttributes objectHeaderAttributes, YapWriter yapWriter, int n, boolean bl) {
        int n2 = yapClass.readFieldCount(yapWriter);
        for (int i = 0; i < n2; ++i) {
            yapClass.i_fields[i].delete(this._family, yapWriter, bl);
        }
        if (yapClass.i_ancestor != null) {
            this.deleteMembers(yapClass.i_ancestor, objectHeaderAttributes, yapWriter, n, bl);
        }
    }

    public boolean findOffset(YapClass yapClass, ObjectHeaderAttributes objectHeaderAttributes, YapReader yapReader, YapField yapField) {
        int n = yapClass.readFieldCount(yapReader);
        for (int i = 0; i < n; ++i) {
            if (yapClass.i_fields[i] == yapField) {
                return true;
            }
            yapReader.incrementOffset(yapClass.i_fields[i].linkLength());
        }
        if (yapClass.i_ancestor == null) {
            return false;
        }
        return this.findOffset(yapClass.i_ancestor, objectHeaderAttributes, yapReader, yapField);
    }

    protected final int headerLength() {
        return 4;
    }

    public void instantiateFields(YapClass yapClass, ObjectHeaderAttributes objectHeaderAttributes, YapObject yapObject, Object object, YapWriter yapWriter) {
        int n = yapClass.readFieldCount(yapWriter);
        try {
            for (int i = 0; i < n; ++i) {
                yapClass.i_fields[i].instantiate(this._family, yapObject, object, yapWriter);
            }
            if (yapClass.i_ancestor != null) {
                this.instantiateFields(yapClass.i_ancestor, objectHeaderAttributes, yapObject, object, yapWriter);
            }
        }
        catch (CorruptionException corruptionException) {
            // empty catch block
        }
    }

    private int linkLength(YapClass yapClass, YapObject yapObject) {
        int n = 4;
        if (yapClass.i_fields != null) {
            for (int i = 0; i < yapClass.i_fields.length; ++i) {
                n += this.linkLength(yapClass.i_fields[i], yapObject);
            }
        }
        if (yapClass.i_ancestor != null) {
            n += this.linkLength(yapClass.i_ancestor, yapObject);
        }
        return n;
    }

    protected int linkLength(YapField yapField, YapObject yapObject) {
        return yapField.linkLength();
    }

    private void marshall(YapClass yapClass, YapObject yapObject, Object object, YapWriter yapWriter, boolean bl) {
        this.marshallDeclaredFields(yapClass, yapObject, object, yapWriter, bl);
    }

    private void marshallDeclaredFields(YapClass yapClass, YapObject yapObject, Object object, YapWriter yapWriter, boolean bl) {
        Config4Class config4Class = yapClass.configOrAncestorConfig();
        yapWriter.writeInt(yapClass.i_fields.length);
        for (int i = 0; i < yapClass.i_fields.length; ++i) {
            Object object2 = yapClass.i_fields[i].getOrCreate(yapWriter.getTransaction(), object);
            if (object2 instanceof Db4oTypeImpl) {
                object2 = ((Db4oTypeImpl)object2).storedTo(yapWriter.getTransaction());
            }
            yapClass.i_fields[i].marshall(yapObject, object2, this._family, yapWriter, config4Class, bl);
        }
        if (yapClass.i_ancestor != null) {
            this.marshallDeclaredFields(yapClass.i_ancestor, yapObject, object, yapWriter, bl);
        }
    }

    protected int marshalledLength(YapField yapField, YapObject yapObject) {
        return 0;
    }

    public YapWriter marshallNew(Transaction transaction, YapObject yapObject, int n) {
        YapWriter yapWriter = this.createWriterForNew(transaction, yapObject, n, this.objectLength(yapObject));
        YapClass yapClass = yapObject.getYapClass();
        Object object = yapObject.getObject();
        if (yapClass.isPrimitive()) {
            ((YapClassPrimitive)yapClass).i_handler.writeNew(MarshallerFamily.current(), object, false, yapWriter, true, false);
        } else {
            yapWriter.writeInt(yapClass.getID());
            yapClass.checkUpdateDepth(yapWriter);
            this.marshall(yapClass, yapObject, object, yapWriter, true);
        }
        return yapWriter;
    }

    public void marshallUpdate(Transaction transaction, int n, YapObject yapObject, Object object) {
        YapWriter yapWriter = this.createWriterForUpdate(transaction, n, yapObject.getID(), 0, this.objectLength(yapObject));
        YapClass yapClass = yapObject.getYapClass();
        yapClass.checkUpdateDepth(yapWriter);
        yapWriter.writeInt(yapClass.getID());
        this.marshall(yapClass, yapObject, object, yapWriter, false);
        this.marshallUpdateWrite(transaction, yapObject, object, yapWriter);
    }

    private int objectLength(YapObject yapObject) {
        return this.headerLength() + this.linkLength(yapObject.getYapClass(), yapObject);
    }

    public ObjectHeaderAttributes readHeaderAttributes(YapReader yapReader) {
        return null;
    }

    public Object readIndexEntry(YapClass yapClass, ObjectHeaderAttributes objectHeaderAttributes, YapField yapField, YapWriter yapWriter) {
        if (yapClass == null) {
            return null;
        }
        if (!this.findOffset(yapClass, objectHeaderAttributes, yapWriter, yapField)) {
            return null;
        }
        return yapField.readIndexEntry(this._family, yapWriter);
    }

    public void readVirtualAttributes(Transaction transaction, YapClass yapClass, YapObject yapObject, ObjectHeaderAttributes objectHeaderAttributes, YapReader yapReader) {
        int n = yapClass.readFieldCount(yapReader);
        for (int i = 0; i < n; ++i) {
            yapClass.i_fields[i].readVirtualAttribute(transaction, yapReader, yapObject);
        }
        if (yapClass.i_ancestor != null) {
            this.readVirtualAttributes(transaction, yapClass.i_ancestor, yapObject, objectHeaderAttributes, yapReader);
        }
    }
}

