/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.inside.ix;

import com.db4o.QCandidates;
import com.db4o.QCon;
import com.db4o.QConObject;
import com.db4o.Tree;
import com.db4o.TreeInt;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Visitor4;
import com.db4o.inside.ix.IxTraverser;
import com.db4o.inside.ix.NIxPath;
import com.db4o.inside.ix.NIxPaths;
import com.db4o.inside.ix.QxProcessor;

class QxPath
extends TreeInt {
    private final QxProcessor _processor;
    private QCon _constraint;
    final QxPath _parent;
    private IxTraverser[] _indexTraversers;
    private NIxPaths[] _ixPaths;
    private Tree _nCandidates;
    private Tree _candidates;
    private final int _depth;

    QxPath(QxProcessor qxProcessor, QxPath qxPath, QCon qCon, int n) {
        super(0);
        this._processor = qxProcessor;
        this._parent = qxPath;
        this._constraint = qCon;
        this._depth = n;
    }

    public Object shallowClone() {
        QxPath qxPath = new QxPath(this._processor, this._parent, this._constraint, this._depth);
        qxPath._indexTraversers = this._indexTraversers;
        qxPath._ixPaths = this._ixPaths;
        qxPath._nCandidates = this._nCandidates;
        qxPath._candidates = this._candidates;
        return super.shallowCloneInternal(qxPath);
    }

    void buildPaths() {
        int n = this._constraint.identityID();
        if (n > 0) {
            this.processChildCandidates(new TreeInt(n));
            return;
        }
        boolean bl = true;
        Iterator4 iterator4 = this._constraint.iterateChildren();
        while (iterator4.hasNext()) {
            bl = false;
            QCon qCon = (QCon)iterator4.next();
            if (!qCon.canLoadByIndex()) continue;
            new QxPath(this._processor, this, qCon, this._depth + 1).buildPaths();
        }
        if (!bl) {
            return;
        }
        if (!this._constraint.canLoadByIndex()) {
            return;
        }
        if (!this._constraint.canBeIndexLeaf()) {
            return;
        }
        this._indexTraversers = new IxTraverser[]{new IxTraverser()};
        this._key = ((QConObject)this._constraint).findBoundsQuery(this._indexTraversers[0]);
        if (this._key < 0) {
            return;
        }
        if (this._key > 0) {
            this._ixPaths = new NIxPaths[]{this._indexTraversers[0].convert()};
            this.expectNixCount(this._ixPaths[0], this._key);
        }
        this._processor.addPath(this);
    }

    private void expectNixCount(NIxPaths nIxPaths, int n) {
    }

    void load() {
        this.loadFromNixPaths();
        if (this._parent == null) {
            return;
        }
        if (this._processor.exceedsLimit(Tree.size(this._nCandidates), this._depth)) {
            return;
        }
        QxPath qxPath = new QxPath(this._processor, this._parent._parent, this._parent._constraint, this._depth - 1);
        qxPath.processChildCandidates(this._nCandidates);
    }

    private void loadFromIndexTraversers() {
        if (this._indexTraversers == null) {
            return;
        }
        for (int i = 0; i < this._indexTraversers.length; ++i) {
            this._indexTraversers[i].visitAll(new Visitor4(){

                public void visit(Object object) {
                    int n = (Integer)object;
                    if (QxPath.this._candidates == null) {
                        QxPath.this._candidates = new TreeInt(n);
                    } else {
                        QxPath.this._candidates = QxPath.this._candidates.add(new TreeInt(n));
                    }
                }
            });
        }
    }

    private void loadFromNixPaths() {
        if (this._ixPaths == null) {
            return;
        }
        for (int i = 0; i < this._ixPaths.length; ++i) {
            if (this._ixPaths[i] == null) continue;
            this._ixPaths[i].traverse(new Visitor4(){

                public void visit(Object object) {
                    int n = (Integer)object;
                    if (QxPath.this._nCandidates == null) {
                        QxPath.this._nCandidates = new TreeInt(n);
                    } else {
                        QxPath.this._nCandidates = QxPath.this._nCandidates.add(new TreeInt(n));
                    }
                }
            });
        }
        this.compareLoadedNixPaths();
    }

    private void compareLoadedNixPaths() {
    }

    void processChildCandidates(Tree tree) {
        if (tree == null) {
            this._processor.addPath(this);
            return;
        }
        if (this._parent == null) {
            this._candidates = tree;
            this._nCandidates = tree;
            this._processor.addPath(this);
            return;
        }
        this._indexTraversers = new IxTraverser[tree.size()];
        this._ixPaths = new NIxPaths[tree.size()];
        final int[] nArray = new int[]{0};
        final boolean[] blArray = new boolean[]{false};
        tree.traverse(new Visitor4(){

            public void visit(Object object) {
                int n = nArray[0];
                nArray[0] = n + 1;
                int n2 = n;
                ((QxPath)QxPath.this)._indexTraversers[n2] = new IxTraverser();
                int n3 = QxPath.this._indexTraversers[n2].findBoundsQuery(QxPath.this._constraint, new Integer(((TreeInt)object)._key));
                if (n3 >= 0) {
                    QxPath.this._key += n3;
                } else {
                    blArray[0] = true;
                }
                if (n3 > 0) {
                    ((QxPath)QxPath.this)._ixPaths[n2] = QxPath.this._indexTraversers[n2].convert();
                    QxPath.this.expectNixCount(QxPath.this._ixPaths[n2], n3);
                }
            }
        });
        if (blArray[0]) {
            return;
        }
        this._processor.addPath(this);
    }

    public boolean isTopLevelComplete() {
        return this._parent == null;
    }

    boolean onSameFieldAs(QxPath qxPath) {
        return this._constraint.onSameFieldAs(qxPath._constraint);
    }

    Tree toQCandidates(QCandidates qCandidates) {
        return TreeInt.toQCandidate((TreeInt)this._nCandidates, qCandidates);
    }

    void mergeForSameField(QxPath qxPath) {
        int n;
        if (qxPath._ixPaths == null) {
            return;
        }
        int n2 = this._ixPaths[0].count();
        for (n = 0; n < qxPath._ixPaths.length; ++n) {
            if (qxPath._ixPaths[n] == null) continue;
            qxPath._ixPaths[n]._paths.traverse(new Visitor4(){

                public void visit(Object object) {
                    QxPath.this._ixPaths[0].add((NIxPath)object);
                }
            });
        }
        n = this._ixPaths[0].count();
        this._key += n - n2;
    }
}

