/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.Db4oTypeImpl;
import com.db4o.ObjectContainer;
import com.db4o.ReplicationRecord;
import com.db4o.Transaction;
import com.db4o.VirtualAttributes;
import com.db4o.YapObject;
import com.db4o.YapStream;
import com.db4o.inside.replication.MigrationConnection;
import com.db4o.query.Query;
import com.db4o.replication.ReplicationConflictHandler;
import com.db4o.replication.ReplicationProcess;

public class ReplicationImpl
implements ReplicationProcess {
    final YapStream _peerA;
    final Transaction _transA;
    final YapStream _peerB;
    final Transaction _transB;
    final ReplicationConflictHandler _conflictHandler;
    final ReplicationRecord _record;
    private int _direction;
    private static final int IGNORE = 0;
    private static final int TO_B = -1;
    private static final int TO_A = 1;
    private static final int CHECK_CONFLICT = -99;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationImpl(YapStream yapStream, ObjectContainer objectContainer, ReplicationConflictHandler replicationConflictHandler) {
        if (replicationConflictHandler == null) {
            throw new NullPointerException();
        }
        Object object = yapStream.ext().lock();
        synchronized (object) {
            Object object2 = objectContainer.ext().lock();
            synchronized (object2) {
                MigrationConnection migrationConnection;
                this._peerA = yapStream;
                this._transA = yapStream.checkTransaction(null);
                this._peerB = (YapStream)objectContainer;
                this._transB = this._peerB.checkTransaction(null);
                this._peerA.i_handlers.i_migration = migrationConnection = new MigrationConnection(this._peerA, this._peerB);
                this._peerA.i_handlers.i_replication = this;
                this._peerA._replicationCallState = -1;
                this._peerB.i_handlers.i_migration = migrationConnection;
                this._peerB.i_handlers.i_replication = this;
                this._peerB._replicationCallState = -1;
                this._conflictHandler = replicationConflictHandler;
                this._record = ReplicationRecord.beginReplication(this._transA, this._transB);
            }
        }
    }

    private int bindAndSet(Transaction transaction, YapStream yapStream, YapObject yapObject, Object object) {
        Db4oTypeImpl db4oTypeImpl;
        if (object instanceof Db4oTypeImpl && !(db4oTypeImpl = (Db4oTypeImpl)object).canBind()) {
            Db4oTypeImpl db4oTypeImpl2 = (Db4oTypeImpl)yapObject.getObject();
            db4oTypeImpl2.replicateFrom(object);
            return yapObject.getID();
        }
        yapStream.bind2(yapObject, object);
        return yapStream.setAfterReplication(transaction, object, 1, true);
    }

    public void checkConflict(Object object) {
        int n = this._direction;
        this._direction = -99;
        this.replicate(object);
        this._direction = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        Object object = this._peerA.lock();
        synchronized (object) {
            Object object2 = this._peerB.lock();
            synchronized (object2) {
                long l;
                this._peerA.commit();
                this._peerB.commit();
                this.endReplication();
                long l2 = this._peerA.currentVersion() - 1L;
                this._record._version = l = this._peerB.currentVersion() - 1L;
                if (l2 > l) {
                    this._record._version = l2;
                    this._peerB.raiseVersion(this._record._version + 1L);
                } else if (l > l2) {
                    this._peerA.raiseVersion(this._record._version + 1L);
                }
                this._record.store(this._peerA);
                this._record.store(this._peerB);
            }
        }
    }

    private void endReplication() {
        this._peerA._replicationCallState = 0;
        this._peerA.i_handlers.i_migration = null;
        this._peerA.i_handlers.i_replication = null;
        this._peerA._replicationCallState = 0;
        this._peerB.i_handlers.i_migration = null;
        this._peerB.i_handlers.i_replication = null;
    }

    private int idInCaller(YapStream yapStream, YapObject yapObject, YapObject yapObject2) {
        return yapStream == this._peerA ? yapObject.getID() : yapObject2.getID();
    }

    private int ignoreOrCheckConflict() {
        if (this._direction == -99) {
            return -99;
        }
        return 0;
    }

    private boolean isInConflict(long l, long l2) {
        if (l > this._record._version && l2 > this._record._version) {
            return true;
        }
        if (l2 > this._record._version && this._direction == -1) {
            return true;
        }
        return l > this._record._version && this._direction == 1;
    }

    private long lastSynchronization() {
        return this._record._version;
    }

    public ObjectContainer peerA() {
        return this._peerA;
    }

    public ObjectContainer peerB() {
        return this._peerB;
    }

    public void replicate(Object object) {
        YapStream yapStream = this._peerB;
        if (this._peerB.isStored(object) && !this._peerA.isStored(object)) {
            yapStream = this._peerA;
        }
        yapStream.set(object);
    }

    public void rollback() {
        this._peerA.rollback();
        this._peerB.rollback();
        this.endReplication();
    }

    public void setDirection(ObjectContainer objectContainer, ObjectContainer objectContainer2) {
        if (objectContainer == this._peerA && objectContainer2 == this._peerB) {
            this._direction = -1;
        }
        if (objectContainer == this._peerB && objectContainer2 == this._peerA) {
            this._direction = 1;
        }
    }

    private void shareBinding(YapObject yapObject, YapObject yapObject2, Object object, YapObject yapObject3, Object object2) {
        if (yapObject == null) {
            return;
        }
        if (object instanceof Db4oTypeImpl && !((Db4oTypeImpl)object).canBind()) {
            return;
        }
        if (yapObject == yapObject2) {
            this._peerB.bind2(yapObject3, object);
        } else {
            this._peerA.bind2(yapObject2, object2);
        }
    }

    private int toA() {
        if (this._direction == -99) {
            return -99;
        }
        if (this._direction != -1) {
            return 1;
        }
        return 0;
    }

    private int toB() {
        if (this._direction == -99) {
            return -99;
        }
        if (this._direction != 1) {
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int tryToHandle(YapStream yapStream, Object object) {
        int n = 0;
        YapStream yapStream2 = null;
        YapObject yapObject = null;
        if (yapStream == this._peerA) {
            yapStream2 = this._peerB;
            if (this._direction == -1) {
                n = -1;
            }
        } else {
            yapStream2 = this._peerA;
            if (this._direction == 1) {
                n = -1;
            }
        }
        Object object2 = yapStream2.i_lock;
        synchronized (object2) {
            Object[] objectArray;
            Object object3 = object;
            Object object4 = object;
            YapObject yapObject2 = this._peerA.getYapObject(object);
            YapObject yapObject3 = this._peerB.getYapObject(object);
            VirtualAttributes virtualAttributes = null;
            VirtualAttributes virtualAttributes2 = null;
            if (yapObject2 == null) {
                if (yapObject3 == null) {
                    return n;
                }
                yapObject = yapObject3;
                virtualAttributes2 = yapObject3.virtualAttributes(this._transB);
                if (virtualAttributes2 == null) {
                    return n;
                }
                objectArray = this._transA.objectAndYapObjectBySignature(virtualAttributes2.i_uuid, virtualAttributes2.i_database.i_signature);
                if (objectArray[0] == null) {
                    return n;
                }
                yapObject2 = (YapObject)objectArray[1];
                object3 = objectArray[0];
                virtualAttributes = yapObject2.virtualAttributes(this._transA);
            } else {
                virtualAttributes = yapObject2.virtualAttributes(this._transA);
                if (virtualAttributes == null) {
                    return n;
                }
                if (yapObject3 == null) {
                    yapObject = yapObject2;
                    objectArray = this._transB.objectAndYapObjectBySignature(virtualAttributes.i_uuid, virtualAttributes.i_database.i_signature);
                    if (objectArray[0] == null) {
                        return n;
                    }
                    yapObject3 = (YapObject)objectArray[1];
                    object4 = objectArray[0];
                } else {
                    yapObject = null;
                }
                virtualAttributes2 = yapObject3.virtualAttributes(this._transB);
            }
            if (virtualAttributes == null || virtualAttributes2 == null) {
                return n;
            }
            if (object3 == object4) {
                if (yapStream == this._peerA && this._direction == -1) {
                    return -1;
                }
                if (yapStream == this._peerB && this._direction == 1) {
                    return -1;
                }
                return this.idInCaller(yapStream, yapObject2, yapObject3);
            }
            this._peerA.refresh(object3, 1);
            this._peerB.refresh(object4, 1);
            if (virtualAttributes.i_version <= this._record._version && virtualAttributes2.i_version <= this._record._version) {
                if (this._direction != -99) {
                    this.shareBinding(yapObject, yapObject2, object3, yapObject3, object4);
                }
                return this.idInCaller(yapStream, yapObject2, yapObject3);
            }
            int n2 = this.ignoreOrCheckConflict();
            if (this.isInConflict(virtualAttributes.i_version, virtualAttributes2.i_version)) {
                Object object5 = this._conflictHandler.resolveConflict(this, object3, object4);
                if (object5 == object3) {
                    int n3 = n2 = this._direction == 1 ? 0 : this.toB();
                }
                if (object5 == object4) {
                    int n4 = n2 = this._direction == -1 ? 0 : this.toA();
                }
                if (n2 == 0) {
                    return -1;
                }
            } else {
                int n5 = n2 = virtualAttributes2.i_version > this._record._version ? this.toA() : this.toB();
            }
            if (n2 == 1) {
                if (!yapObject3.isActive()) {
                    yapObject3.activate(this._transB, object4, 1, false);
                }
                int n6 = this.bindAndSet(this._transA, this._peerA, yapObject2, object4);
                if (yapStream == this._peerA) {
                    return n6;
                }
            }
            if (n2 == -1) {
                if (!yapObject2.isActive()) {
                    yapObject2.activate(this._transA, object3, 1, false);
                }
                int n7 = this.bindAndSet(this._transB, this._peerB, yapObject3, object3);
                if (yapStream == this._peerB) {
                    return n7;
                }
            }
            return this.idInCaller(yapStream, yapObject2, yapObject3);
        }
    }

    public void whereModified(Query query) {
        query.descend("v4oversion").constrain(new Long(this.lastSynchronization())).greater();
    }
}

