/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.YapClass;
import com.db4o.YapClassCollection;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Queue4;

class PendingClassInits {
    private final YapClassCollection _classColl;
    private Collection4 _pending = new Collection4();
    private Queue4 _members = new Queue4();
    private Queue4 _statics = new Queue4();
    private Queue4 _writes = new Queue4();
    private Queue4 _inits = new Queue4();
    private boolean _running = false;

    PendingClassInits(YapClassCollection yapClassCollection) {
        this._classColl = yapClassCollection;
    }

    void process(YapClass yapClass) {
        if (this._pending.contains(yapClass)) {
            return;
        }
        YapClass yapClass2 = yapClass.getAncestor();
        if (yapClass2 != null) {
            this.process(yapClass2);
        }
        this._pending.add(yapClass);
        this._members.add(yapClass);
        if (this._running) {
            return;
        }
        this._running = true;
        this.checkInits();
        this._pending = new Collection4();
        this._running = false;
    }

    private void checkMembers() {
        while (this._members.hasNext()) {
            YapClass yapClass = (YapClass)this._members.next();
            yapClass.addMembers(this._classColl.i_stream);
            this._statics.add(yapClass);
        }
    }

    private void checkStatics() {
        this.checkMembers();
        while (this._statics.hasNext()) {
            YapClass yapClass = (YapClass)this._statics.next();
            yapClass.storeStaticFieldValues(this._classColl.i_systemTrans, true);
            this._writes.add(yapClass);
            this.checkMembers();
        }
    }

    private void checkWrites() {
        this.checkStatics();
        while (this._writes.hasNext()) {
            YapClass yapClass = (YapClass)this._writes.next();
            yapClass.setStateDirty();
            yapClass.write(this._classColl.i_systemTrans);
            this._inits.add(yapClass);
            this.checkStatics();
        }
    }

    private void checkInits() {
        this.checkWrites();
        while (this._inits.hasNext()) {
            YapClass yapClass = (YapClass)this._inits.next();
            yapClass.initConfigOnUp(this._classColl.i_systemTrans);
            this.checkWrites();
        }
    }
}

