/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.inside.cluster;

import com.db4o.cluster.Cluster;
import com.db4o.inside.Exceptions4;
import com.db4o.query.Constraint;

public class ClusterConstraint
implements Constraint {
    final Cluster _cluster;
    final Constraint[] _constraints;

    public ClusterConstraint(Cluster cluster, Constraint[] constraintArray) {
        this._cluster = cluster;
        this._constraints = constraintArray;
    }

    private ClusterConstraint compatible(Constraint constraint) {
        if (!(constraint instanceof ClusterConstraint)) {
            throw new IllegalArgumentException();
        }
        ClusterConstraint clusterConstraint = (ClusterConstraint)constraint;
        if (clusterConstraint._constraints.length != this._constraints.length) {
            throw new IllegalArgumentException();
        }
        return clusterConstraint;
    }

    public Constraint and(Constraint constraint) {
        return this.join(constraint, true);
    }

    public Constraint or(Constraint constraint) {
        return this.join(constraint, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Constraint join(Constraint constraint, boolean bl) {
        Cluster cluster = this._cluster;
        synchronized (cluster) {
            ClusterConstraint clusterConstraint = this.compatible(constraint);
            Constraint[] constraintArray = new Constraint[this._constraints.length];
            for (int i = 0; i < this._constraints.length; ++i) {
                constraintArray[i] = bl ? this._constraints[i].and(clusterConstraint._constraints[i]) : this._constraints[i].or(clusterConstraint._constraints[i]);
            }
            return new ClusterConstraint(this._cluster, constraintArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint equal() {
        Cluster cluster = this._cluster;
        synchronized (cluster) {
            for (int i = 0; i < this._constraints.length; ++i) {
                this._constraints[i].equal();
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint greater() {
        Cluster cluster = this._cluster;
        synchronized (cluster) {
            for (int i = 0; i < this._constraints.length; ++i) {
                this._constraints[i].greater();
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint smaller() {
        Cluster cluster = this._cluster;
        synchronized (cluster) {
            for (int i = 0; i < this._constraints.length; ++i) {
                this._constraints[i].smaller();
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint identity() {
        Cluster cluster = this._cluster;
        synchronized (cluster) {
            for (int i = 0; i < this._constraints.length; ++i) {
                this._constraints[i].identity();
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint like() {
        Cluster cluster = this._cluster;
        synchronized (cluster) {
            for (int i = 0; i < this._constraints.length; ++i) {
                this._constraints[i].like();
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint startsWith(boolean bl) {
        Cluster cluster = this._cluster;
        synchronized (cluster) {
            for (int i = 0; i < this._constraints.length; ++i) {
                this._constraints[i].startsWith(bl);
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint endsWith(boolean bl) {
        Cluster cluster = this._cluster;
        synchronized (cluster) {
            for (int i = 0; i < this._constraints.length; ++i) {
                this._constraints[i].endsWith(bl);
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint contains() {
        Cluster cluster = this._cluster;
        synchronized (cluster) {
            for (int i = 0; i < this._constraints.length; ++i) {
                this._constraints[i].contains();
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint not() {
        Cluster cluster = this._cluster;
        synchronized (cluster) {
            for (int i = 0; i < this._constraints.length; ++i) {
                this._constraints[i].not();
            }
            return this;
        }
    }

    public Object getObject() {
        Exceptions4.notSupported();
        return null;
    }
}

