/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.Config4Class;
import com.db4o.Config4Impl;
import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectServer;
import com.db4o.ObjectSet;
import com.db4o.User;
import com.db4o.YapClient;
import com.db4o.YapFile;
import com.db4o.YapServerThread;
import com.db4o.config.Configuration;
import com.db4o.ext.ExtObjectServer;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Cool;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Visitor4;
import com.db4o.foundation.network.YapServerSocket;
import com.db4o.foundation.network.YapSocketFake;
import com.db4o.foundation.network.YapSocketFakeServer;
import com.db4o.inside.Exceptions4;
import java.io.IOException;

class YapServer
implements ObjectServer,
ExtObjectServer,
Runnable,
YapSocketFakeServer {
    private String i_name;
    private YapServerSocket i_serverSocket;
    private int i_threadIDGen = 1;
    private Collection4 i_threads = new Collection4();
    private YapFile i_yapFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    YapServer(final YapFile yapFile, int n) {
        yapFile.setServer(true);
        this.i_name = "db4o ServerSocket  FILE: " + yapFile.toString() + "  PORT:" + n;
        this.i_yapFile = yapFile;
        Config4Impl config4Impl = (Config4Impl)this.i_yapFile.configure();
        config4Impl.callbacks(false);
        config4Impl.isServer(true);
        yapFile.getYapClass(yapFile.i_handlers.ICLASS_STATICCLASS, true);
        config4Impl.exceptionalClasses().forEachValue(new Visitor4(){

            public void visit(Object object) {
                yapFile.getYapClass(yapFile.reflector().forName(((Config4Class)object).getName()), true);
            }
        });
        if (config4Impl.messageLevel() == 0) {
            config4Impl.messageLevel(1);
        }
        if (n > 0) {
            try {
                this.i_serverSocket = new YapServerSocket(n);
                this.i_serverSocket.setSoTimeout(config4Impl.timeoutServerSocket());
            }
            catch (IOException iOException) {
                Exceptions4.throwRuntimeException(30, "" + n);
            }
            new Thread(this).start();
            YapServer yapServer = this;
            synchronized (yapServer) {
                try {
                    this.wait(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void backup(String string) throws IOException {
        this.i_yapFile.backup(string);
    }

    final void checkClosed() {
        if (this.i_yapFile == null) {
            Exceptions4.throwRuntimeException(20, this.i_name);
        }
        this.i_yapFile.checkClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        Object object = Db4o.lock;
        synchronized (object) {
            Cool.sleepIgnoringInterruption(100L);
            try {
                if (this.i_serverSocket != null) {
                    this.i_serverSocket.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.i_serverSocket = null;
            boolean bl = this.i_yapFile == null ? true : this.i_yapFile.close();
            Collection4 collection4 = this.i_threads;
            synchronized (collection4) {
                Iterator4 iterator4 = this.i_threads.iterator();
                while (iterator4.hasNext()) {
                    ((YapServerThread)iterator4.next()).close();
                }
            }
            this.i_yapFile = null;
            return bl;
        }
    }

    public Configuration configure() {
        return this.i_yapFile.configure();
    }

    public ExtObjectServer ext() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    YapServerThread findThread(int n) {
        Collection4 collection4 = this.i_threads;
        synchronized (collection4) {
            Iterator4 iterator4 = this.i_threads.iterator();
            while (iterator4.hasNext()) {
                YapServerThread yapServerThread = (YapServerThread)iterator4.next();
                if (yapServerThread.i_threadID != n) continue;
                return yapServerThread;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantAccess(String string, String string2) {
        Object object = this.i_yapFile.i_lock;
        synchronized (object) {
            this.checkClosed();
            User user = new User();
            user.name = string;
            this.i_yapFile.showInternalClasses(true);
            User user2 = (User)this.i_yapFile.get(user).next();
            if (user2 != null) {
                user2.password = string2;
                this.i_yapFile.set(user2);
            } else {
                user.password = string2;
                this.i_yapFile.set(user);
            }
            this.i_yapFile.commit();
            this.i_yapFile.showInternalClasses(false);
        }
    }

    public ObjectContainer objectContainer() {
        return this.i_yapFile;
    }

    public ObjectContainer openClient() {
        try {
            return new YapClient(this.openClientSocket(), "embedded client" + (this.i_threadIDGen - 1), "", false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YapSocketFake openClientSocket() {
        int n = ((Config4Impl)this.configure()).timeoutClientSocket();
        YapSocketFake yapSocketFake = new YapSocketFake(this, n);
        YapSocketFake yapSocketFake2 = new YapSocketFake(this, n, yapSocketFake);
        try {
            YapServerThread yapServerThread = new YapServerThread(this, this.i_yapFile, yapSocketFake2, this.i_threadIDGen++, true);
            Collection4 collection4 = this.i_threads;
            synchronized (collection4) {
                this.i_threads.add(yapServerThread);
            }
            yapServerThread.start();
            return yapSocketFake;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeThread(YapServerThread yapServerThread) {
        Collection4 collection4 = this.i_threads;
        synchronized (collection4) {
            this.i_threads.remove(yapServerThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeAccess(String string) {
        Object object = this.i_yapFile.i_lock;
        synchronized (object) {
            this.i_yapFile.showInternalClasses(true);
            this.checkClosed();
            User user = new User();
            user.name = string;
            ObjectSet objectSet = this.i_yapFile.get(user);
            while (objectSet.hasNext()) {
                this.i_yapFile.delete(objectSet.next());
            }
            this.i_yapFile.commit();
            this.i_yapFile.showInternalClasses(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread.currentThread().setName(this.i_name);
        this.i_yapFile.logMsg(31, "" + this.i_serverSocket.getLocalPort());
        Runnable runnable = this;
        synchronized (runnable) {
            this.notify();
        }
        while (this.i_serverSocket != null) {
            try {
                runnable = new YapServerThread(this, this.i_yapFile, this.i_serverSocket.accept(), this.i_threadIDGen++, false);
                Collection4 collection4 = this.i_threads;
                synchronized (collection4) {
                    this.i_threads.add(runnable);
                }
                ((Thread)runnable).start();
            }
            catch (Exception exception) {}
        }
    }
}

