/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.Transaction;
import com.db4o.YapMeta;
import com.db4o.YapStream;
import com.db4o.foundation.BitMap4;

public class YapReader {
    byte[] _buffer;
    public int _offset;

    YapReader() {
    }

    public YapReader(int n) {
        this._buffer = new byte[n];
    }

    public void append(byte by) {
        this._buffer[this._offset++] = by;
    }

    void append(byte[] byArray) {
        System.arraycopy(byArray, 0, this._buffer, this._offset, byArray.length);
        this._offset += byArray.length;
    }

    final boolean containsTheSame(YapReader yapReader) {
        if (yapReader != null) {
            byte[] byArray = yapReader._buffer;
            if (this._buffer == null) {
                return byArray == null;
            }
            if (byArray != null && this._buffer.length == byArray.length) {
                int n = this._buffer.length;
                for (int i = 0; i < n; ++i) {
                    if (this._buffer[i] == byArray[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int getLength() {
        return this._buffer.length;
    }

    public void incrementOffset(int n) {
        this._offset += n;
    }

    public void read(YapStream yapStream, int n, int n2) {
        yapStream.readBytes(this._buffer, n, n2, this.getLength());
    }

    public final void readBegin(byte by) {
    }

    public BitMap4 readBitMap(int n) {
        BitMap4 bitMap4 = new BitMap4(this._buffer, this._offset, n);
        this._offset += bitMap4.marshalledLength();
        return bitMap4;
    }

    public byte readByte() {
        return this._buffer[this._offset++];
    }

    byte[] readBytes(int n) {
        byte[] byArray = new byte[n];
        this.readBytes(byArray);
        return byArray;
    }

    void readBytes(byte[] byArray) {
        int n = byArray.length;
        System.arraycopy(this._buffer, this._offset, byArray, 0, n);
        this._offset += n;
    }

    public final YapReader readEmbeddedObject(Transaction transaction) {
        return transaction.i_stream.readObjectReaderByAddress(this.readInt(), this.readInt());
    }

    void readEncrypt(YapStream yapStream, int n) {
        yapStream.readBytes(this._buffer, n, this.getLength());
        yapStream.i_handlers.decrypt(this);
    }

    public void readEnd() {
    }

    public final int readInt() {
        int n = (this._offset += 4) - 1;
        return this._buffer[n] & 0xFF | (this._buffer[--n] & 0xFF) << 8 | (this._buffer[--n] & 0xFF) << 16 | this._buffer[--n] << 24;
    }

    public YapReader readPayloadReader(int n, int n2) {
        YapReader yapReader = new YapReader(n2);
        System.arraycopy(this._buffer, n, yapReader._buffer, 0, n2);
        return yapReader;
    }

    void replaceWith(byte[] byArray) {
        System.arraycopy(byArray, 0, this._buffer, 0, this.getLength());
    }

    public String toString() {
        try {
            String string = "";
            for (int i = 0; i < this._buffer.length; ++i) {
                if (i > 0) {
                    string = string + " , ";
                }
                string = string + this._buffer[i];
            }
            return string;
        }
        catch (Exception exception) {
            return "";
        }
    }

    void writeBegin(byte by) {
    }

    public void writeBegin(byte by, int n) {
    }

    public void writeBitMap(BitMap4 bitMap4) {
        bitMap4.writeTo(this._buffer, this._offset);
        this._offset += bitMap4.marshalledLength();
    }

    public void writeEnd() {
    }

    public final void writeInt(int n) {
        int n2 = this._offset + 4;
        this._offset = n2--;
        byte[] byArray = this._buffer;
        byArray[n2] = (byte)n;
        byArray[--n2] = (byte)(n >>= 8);
        byArray[--n2] = (byte)(n >>= 8);
        byArray[--n2] = (byte)(n >>= 8);
    }

    public void writeIDOf(Transaction transaction, Object object) {
        if (object == null) {
            this.writeInt(0);
            return;
        }
        if (object instanceof YapMeta) {
            ((YapMeta)object).writeOwnID(transaction, this);
            return;
        }
        this.writeInt((Integer)object);
    }

    public void writeIDOf(Transaction transaction, YapMeta yapMeta) {
        if (yapMeta == null) {
            this.writeInt(0);
            return;
        }
        yapMeta.writeOwnID(transaction, this);
    }

    public void writeIDOf(Transaction transaction, Integer n) {
        this.writeInt(n);
    }

    void writeShortString(Transaction transaction, String string) {
        transaction.i_stream.i_handlers.i_stringHandler.writeShort(string, this);
    }
}

