/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.PendingClassInits;
import com.db4o.Transaction;
import com.db4o.UseSystemTransaction;
import com.db4o.YapClass;
import com.db4o.YapClassCollectionIterator;
import com.db4o.YapField;
import com.db4o.YapMeta;
import com.db4o.YapReader;
import com.db4o.YapStream;
import com.db4o.ext.StoredClass;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Queue4;
import com.db4o.foundation.Visitor4;
import com.db4o.reflect.ReflectClass;

public final class YapClassCollection
extends YapMeta
implements UseSystemTransaction {
    private YapClass i_addingMembersTo;
    private Collection4 i_classes;
    private Hashtable4 i_creating;
    final YapStream i_stream;
    final Transaction i_systemTrans;
    private Hashtable4 i_yapClassByBytes;
    private Hashtable4 i_yapClassByClass;
    private Hashtable4 i_yapClassByID;
    private int i_yapClassCreationDepth;
    private Queue4 i_initYapClassesOnUp;
    private final PendingClassInits _classInits;

    YapClassCollection(Transaction transaction) {
        this.i_systemTrans = transaction;
        this.i_stream = transaction.i_stream;
        this.i_initYapClassesOnUp = new Queue4();
        this._classInits = new PendingClassInits(this);
    }

    void addYapClass(YapClass yapClass) {
        this.i_stream.setDirty(this);
        this.i_classes.add(yapClass);
        if (yapClass.stateUnread()) {
            this.i_yapClassByBytes.put(yapClass.i_nameBytes, (Object)yapClass);
        } else {
            this.i_yapClassByClass.put(yapClass.classReflector(), (Object)yapClass);
        }
        if (yapClass.getID() == 0) {
            yapClass.write(this.i_systemTrans);
        }
        this.i_yapClassByID.put(yapClass.getID(), (Object)yapClass);
    }

    private byte[] asBytes(String string) {
        return this.i_stream.stringIO().write(string);
    }

    void attachQueryNode(final String string, final Visitor4 visitor4) {
        YapClassCollectionIterator yapClassCollectionIterator = this.iterator();
        while (yapClassCollectionIterator.hasNext()) {
            final YapClass yapClass = yapClassCollectionIterator.readNextClass();
            if (yapClass.isInternal()) continue;
            yapClass.forEachYapField(new Visitor4(){

                public void visit(Object object) {
                    YapField yapField = (YapField)object;
                    if (yapField.canAddToQuery(string)) {
                        visitor4.visit(new Object[]{yapClass, yapField});
                    }
                }
            });
        }
    }

    void checkChanges() {
        Iterator4 iterator4 = this.i_classes.iterator();
        while (iterator4.hasNext()) {
            ((YapClass)iterator4.next()).checkChanges();
        }
    }

    final boolean createYapClass(YapClass yapClass, ReflectClass reflectClass) {
        ++this.i_yapClassCreationDepth;
        ReflectClass reflectClass2 = reflectClass.getSuperclass();
        YapClass yapClass2 = null;
        if (reflectClass2 != null && !reflectClass2.equals(this.i_stream.i_handlers.ICLASS_OBJECT)) {
            yapClass2 = this.getYapClass(reflectClass2, true);
        }
        boolean bl = this.i_stream.createYapClass(yapClass, reflectClass, yapClass2);
        --this.i_yapClassCreationDepth;
        this.initYapClassesOnUp();
        return bl;
    }

    boolean fieldExists(String string) {
        YapClassCollectionIterator yapClassCollectionIterator = this.iterator();
        while (yapClassCollectionIterator.hasNext()) {
            if (yapClassCollectionIterator.readNextClass().getYapField(string) == null) continue;
            return true;
        }
        return false;
    }

    Collection4 forInterface(ReflectClass reflectClass) {
        Collection4 collection4 = new Collection4();
        YapClassCollectionIterator yapClassCollectionIterator = this.iterator();
        while (yapClassCollectionIterator.hasNext()) {
            YapClass yapClass = yapClassCollectionIterator.readNextClass();
            ReflectClass reflectClass2 = yapClass.classReflector();
            if (reflectClass2.isInterface() || !reflectClass.isAssignableFrom(reflectClass2)) continue;
            collection4.add(yapClass);
            Iterator4 iterator4 = collection4.iterator();
            while (iterator4.hasNext()) {
                YapClass yapClass2;
                YapClass yapClass3 = (YapClass)iterator4.next();
                if (yapClass3 == yapClass || (yapClass2 = yapClass.getHigherHierarchy(yapClass3)) == null) continue;
                if (yapClass2 == yapClass) {
                    collection4.remove(yapClass3);
                    continue;
                }
                collection4.remove(yapClass);
            }
        }
        return collection4;
    }

    public byte getIdentifier() {
        return 65;
    }

    YapClass getActiveYapClass(ReflectClass reflectClass) {
        return (YapClass)this.i_yapClassByClass.get(reflectClass);
    }

    YapClass getYapClass(ReflectClass reflectClass, boolean bl) {
        int n;
        YapClass yapClass = (YapClass)this.i_yapClassByClass.get(reflectClass);
        if (yapClass == null) {
            yapClass = (YapClass)this.i_yapClassByBytes.remove(this.getNameBytes(reflectClass.getName()));
            this.readYapClass(yapClass, reflectClass);
        }
        if (yapClass != null || !bl) {
            return yapClass;
        }
        yapClass = (YapClass)this.i_creating.get(reflectClass);
        if (yapClass != null) {
            return yapClass;
        }
        yapClass = new YapClass(this.i_stream, reflectClass);
        this.i_creating.put(reflectClass, (Object)yapClass);
        if (!this.createYapClass(yapClass, reflectClass)) {
            this.i_creating.remove(reflectClass);
            return null;
        }
        boolean bl2 = false;
        if (this.i_yapClassByClass.get(reflectClass) == null) {
            this.addYapClass(yapClass);
            bl2 = true;
        }
        if ((n = yapClass.getID()) == 0) {
            yapClass.write(this.i_stream.getSystemTransaction());
            n = yapClass.getID();
        }
        if (this.i_yapClassByID.get(n) == null) {
            this.i_yapClassByID.put(n, (Object)yapClass);
            bl2 = true;
        }
        if (bl2 || yapClass.i_fields == null) {
            this._classInits.process(yapClass);
        }
        this.i_creating.remove(reflectClass);
        this.i_stream.setDirty(this);
        return yapClass;
    }

    YapClass getYapClass(int n) {
        return this.readYapClass((YapClass)this.i_yapClassByID.get(n), null);
    }

    public YapClass getYapClass(String string) {
        YapClass yapClass = (YapClass)this.i_yapClassByBytes.remove(this.getNameBytes(string));
        this.readYapClass(yapClass, null);
        if (yapClass == null) {
            YapClassCollectionIterator yapClassCollectionIterator = this.iterator();
            while (yapClassCollectionIterator.hasNext()) {
                yapClass = (YapClass)yapClassCollectionIterator.next();
                if (!string.equals(yapClass.getName())) continue;
                this.readYapClass(yapClass, null);
                return yapClass;
            }
            return null;
        }
        return yapClass;
    }

    public int getYapClassID(String string) {
        YapClass yapClass = (YapClass)this.i_yapClassByBytes.get(this.getNameBytes(string));
        if (yapClass != null) {
            return yapClass.getID();
        }
        return 0;
    }

    private byte[] getNameBytes(String string) {
        return this.asBytes(this.resolveAlias(string));
    }

    private String resolveAlias(String string) {
        return this.i_stream.i_config.resolveAlias(string);
    }

    void initOnUp(Transaction transaction) {
        ++this.i_yapClassCreationDepth;
        transaction.i_stream.showInternalClasses(true);
        Iterator4 iterator4 = this.i_classes.iterator();
        while (iterator4.hasNext()) {
            ((YapClass)iterator4.next()).initOnUp(transaction);
        }
        transaction.i_stream.showInternalClasses(false);
        --this.i_yapClassCreationDepth;
        this.initYapClassesOnUp();
    }

    void initTables(int n) {
        this.i_classes = new Collection4();
        this.i_yapClassByBytes = new Hashtable4(n);
        if (n < 16) {
            n = 16;
        }
        this.i_yapClassByClass = new Hashtable4(n);
        this.i_yapClassByID = new Hashtable4(n);
        this.i_creating = new Hashtable4(1);
    }

    private void initYapClassesOnUp() {
        if (this.i_yapClassCreationDepth == 0) {
            YapClass yapClass = (YapClass)this.i_initYapClassesOnUp.next();
            while (yapClass != null) {
                yapClass.initOnUp(this.i_systemTrans);
                yapClass = (YapClass)this.i_initYapClassesOnUp.next();
            }
        }
    }

    YapClassCollectionIterator iterator() {
        return new YapClassCollectionIterator(this, this.i_classes._first);
    }

    public int ownLength() {
        return 4 + this.i_classes.size() * 4;
    }

    void purge() {
        Iterator4 iterator4 = this.i_classes.iterator();
        while (iterator4.hasNext()) {
            ((YapClass)iterator4.next()).purge();
        }
    }

    public final void readThis(Transaction transaction, YapReader yapReader) {
        int n = yapReader.readInt();
        this.initTables(n);
        for (int i = n; i > 0; --i) {
            YapClass yapClass = new YapClass(this.i_stream, null);
            int n2 = yapReader.readInt();
            yapClass.setID(n2);
            this.i_classes.add(yapClass);
            this.i_yapClassByID.put(n2, (Object)yapClass);
            this.i_yapClassByBytes.put(yapClass.readName(transaction), (Object)yapClass);
        }
        this.applyReadAs();
    }

    private void applyReadAs() {
        final Hashtable4 hashtable4 = this.i_stream.i_config.readAs();
        hashtable4.forEachKey(new Visitor4(){

            public void visit(Object object) {
                YapClass yapClass;
                String string = (String)object;
                byte[] byArray = YapClassCollection.this.getNameBytes(string);
                String string2 = (String)hashtable4.get(string);
                byte[] byArray2 = YapClassCollection.this.getNameBytes(string2);
                if (YapClassCollection.this.i_yapClassByBytes.get(byArray2) == null && (yapClass = (YapClass)YapClassCollection.this.i_yapClassByBytes.get(byArray)) != null) {
                    yapClass.i_nameBytes = byArray2;
                    yapClass.setConfig(YapClassCollection.this.i_stream.i_config.configClass(string));
                    YapClassCollection.this.i_yapClassByBytes.put(byArray, (Object)null);
                    YapClassCollection.this.i_yapClassByBytes.put(byArray2, (Object)yapClass);
                }
            }
        });
    }

    YapClass readYapClass(YapClass yapClass, ReflectClass reflectClass) {
        if (yapClass != null && !yapClass.stateUnread()) {
            return yapClass;
        }
        ++this.i_yapClassCreationDepth;
        if (yapClass != null && yapClass.stateUnread()) {
            yapClass.createConfigAndConstructor(this.i_yapClassByBytes, this.i_stream, reflectClass);
            ReflectClass reflectClass2 = yapClass.classReflector();
            if (reflectClass2 != null) {
                this.i_yapClassByClass.put(reflectClass2, (Object)yapClass);
                yapClass.readThis();
                yapClass.checkChanges();
                this.i_initYapClassesOnUp.add(yapClass);
            }
        }
        --this.i_yapClassCreationDepth;
        this.initYapClassesOnUp();
        return yapClass;
    }

    void refreshClasses() {
        YapClass yapClass;
        YapClassCollection yapClassCollection = new YapClassCollection(this.i_systemTrans);
        yapClassCollection.i_id = this.i_id;
        yapClassCollection.read(this.i_stream.getSystemTransaction());
        Iterator4 iterator4 = yapClassCollection.i_classes.iterator();
        while (iterator4.hasNext()) {
            yapClass = (YapClass)iterator4.next();
            if (this.i_yapClassByID.get(yapClass.getID()) != null) continue;
            this.i_classes.add(yapClass);
            this.i_yapClassByID.put(yapClass.getID(), (Object)yapClass);
            if (yapClass.stateUnread()) {
                this.i_yapClassByBytes.put(yapClass.readName(this.i_systemTrans), (Object)yapClass);
                continue;
            }
            this.i_yapClassByClass.put(yapClass.classReflector(), (Object)yapClass);
        }
        iterator4 = this.i_classes.iterator();
        while (iterator4.hasNext()) {
            yapClass = (YapClass)iterator4.next();
            yapClass.refresh();
        }
    }

    void reReadYapClass(YapClass yapClass) {
        if (yapClass != null) {
            this.reReadYapClass(yapClass.i_ancestor);
            yapClass.readName(this.i_systemTrans);
            yapClass.forceRead();
            yapClass.setStateClean();
            yapClass.bitFalse(6);
            yapClass.bitFalse(8);
            yapClass.bitFalse(4);
            yapClass.bitFalse(7);
            yapClass.checkChanges();
        }
    }

    public StoredClass[] storedClasses() {
        Object[] objectArray;
        Collection4 collection4 = new Collection4();
        Iterator4 iterator4 = this.i_classes.iterator();
        while (iterator4.hasNext()) {
            objectArray = (Object[])iterator4.next();
            this.readYapClass((YapClass)objectArray, null);
            if (objectArray.classReflector() == null) {
                objectArray.forceRead();
            }
            collection4.add(objectArray);
        }
        this.applyReadAs();
        objectArray = new StoredClass[collection4.size()];
        collection4.toArray(objectArray);
        return objectArray;
    }

    public void writeThis(Transaction transaction, YapReader yapReader) {
        yapReader.writeInt(this.i_classes.size());
        Iterator4 iterator4 = this.i_classes.iterator();
        while (iterator4.hasNext()) {
            yapReader.writeIDOf(transaction, iterator4.next());
        }
    }

    public String toString() {
        return super.toString();
    }
}

