/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.DeleteInfo;
import com.db4o.TransactionListener;
import com.db4o.Tree;
import com.db4o.TreeInt;
import com.db4o.TreeIntObject;
import com.db4o.TreeReader;
import com.db4o.VirtualAttributes;
import com.db4o.YapClass;
import com.db4o.YapFile;
import com.db4o.YapObject;
import com.db4o.YapStream;
import com.db4o.YapWriter;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4Impl;
import com.db4o.foundation.List4;
import com.db4o.foundation.Visitor4;
import com.db4o.inside.btree.BTree;
import com.db4o.inside.ix.IndexTransaction;
import com.db4o.inside.ix.IxTraverser;
import com.db4o.inside.ix.IxTree;
import com.db4o.inside.marshall.ObjectHeader;
import com.db4o.inside.slots.Slot;
import com.db4o.inside.slots.SlotChange;
import com.db4o.reflect.Reflector;

public class Transaction {
    private Tree _slotChanges;
    private int i_address;
    private Tree i_addToClassIndex;
    private final byte[] _pointerBuffer = new byte[8];
    public Tree i_delete;
    private List4 i_dirtyFieldIndexes;
    private Tree _dirtyBTrees;
    public final YapFile i_file;
    final Transaction i_parentTransaction;
    private final YapWriter i_pointerIo;
    private Tree i_removeFromClassIndex;
    public final YapStream i_stream;
    private List4 i_transactionListeners;
    protected Tree i_writtenUpdateDeletedMembers;

    Transaction(YapStream yapStream, Transaction transaction) {
        this.i_stream = yapStream;
        this.i_file = yapStream instanceof YapFile ? (YapFile)yapStream : null;
        this.i_parentTransaction = transaction;
        this.i_pointerIo = new YapWriter(this, 8);
    }

    public void addDirtyFieldIndex(IndexTransaction indexTransaction) {
        this.i_dirtyFieldIndexes = new List4(this.i_dirtyFieldIndexes, indexTransaction);
    }

    void addToClassIndex(int n, int n2) {
    }

    private final Tree addToClassIndexTree(Tree tree, int n, int n2) {
        Tree[] treeArray = new TreeIntObject[]{new TreeIntObject(n)};
        tree = this.createClassIndexNode(tree, treeArray);
        ((TreeIntObject)treeArray[0])._object = Tree.add((Tree)((TreeIntObject)treeArray[0])._object, new TreeInt(n2));
        return tree;
    }

    public void addTransactionListener(TransactionListener transactionListener) {
        this.i_transactionListeners = new List4(this.i_transactionListeners, transactionListener);
    }

    private void appendSlotChanges(final YapWriter yapWriter) {
        if (this.i_parentTransaction != null) {
            this.i_parentTransaction.appendSlotChanges(yapWriter);
        }
        Tree.traverse(this._slotChanges, new Visitor4(){

            public void visit(Object object) {
                ((Tree)object).write(yapWriter);
            }
        });
    }

    void beginEndSet() {
        if (this.i_delete != null) {
            final boolean[] blArray = new boolean[]{false};
            final Transaction transaction = this;
            do {
                blArray[0] = false;
                Tree tree = this.i_delete;
                this.i_delete = null;
                tree.traverse(new Visitor4(){

                    public void visit(Object object) {
                        DeleteInfo deleteInfo = (DeleteInfo)object;
                        if (deleteInfo._delete) {
                            blArray[0] = true;
                            Object object2 = null;
                            if (deleteInfo._reference != null) {
                                object2 = deleteInfo._reference.getObject();
                            }
                            if (object2 == null) {
                                Object[] objectArray = transaction.i_stream.getObjectAndYapObjectByID(transaction, deleteInfo._key);
                                object2 = objectArray[0];
                                deleteInfo._reference = (YapObject)objectArray[1];
                            }
                            Transaction.this.i_stream.delete4(transaction, deleteInfo._reference, object2, deleteInfo._cascade, false);
                        }
                        Transaction.this.i_delete = Tree.add(Transaction.this.i_delete, new DeleteInfo(deleteInfo._key, null, false, deleteInfo._cascade));
                    }
                });
            } while (blArray[0]);
        }
        this.i_delete = null;
        this.i_writtenUpdateDeletedMembers = null;
    }

    private final void clearAll() {
        this._slotChanges = null;
        this._dirtyBTrees = null;
        this.i_addToClassIndex = null;
        this.i_removeFromClassIndex = null;
        this.i_dirtyFieldIndexes = null;
        this.i_transactionListeners = null;
    }

    void close(boolean bl) {
        try {
            if (this.i_stream != null) {
                this.i_stream.releaseSemaphores(this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            try {
                this.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit() {
        Object object = this.i_stream.i_lock;
        synchronized (object) {
            this.i_file.freeSpaceBeginCommit();
            this.commitExceptForFreespace();
            this.i_file.freeSpaceEndCommit();
        }
    }

    private void commitExceptForFreespace() {
        this.commit1BeginEndSet();
        this.commit2Listeners();
        this.commit3Stream();
        this.commit4FieldIndexes();
        this.commit5writeClassIndexChanges();
        this.i_stream.writeDirty();
        this.commit6WriteChanges();
        this.freeOnCommit();
        this.commit7ClearAll();
    }

    private void commit1BeginEndSet() {
        if (this.i_parentTransaction != null) {
            this.i_parentTransaction.commit1BeginEndSet();
        }
        this.beginEndSet();
    }

    private void commit2Listeners() {
        if (this.i_parentTransaction != null) {
            this.i_parentTransaction.commit2Listeners();
        }
        this.commitTransactionListeners();
    }

    private void commit3Stream() {
        this.i_stream.checkNeededUpdates();
        this.i_stream.writeDirty();
        this.i_stream.i_classCollection.write(this.i_stream.getSystemTransaction());
    }

    private void commit4FieldIndexes() {
        if (this.i_parentTransaction != null) {
            this.i_parentTransaction.commit4FieldIndexes();
        }
        if (this.i_dirtyFieldIndexes != null) {
            Iterator4Impl iterator4Impl = new Iterator4Impl(this.i_dirtyFieldIndexes);
            while (iterator4Impl.hasNext()) {
                ((IndexTransaction)iterator4Impl.next()).commit();
            }
        }
    }

    private void commit5writeClassIndexChanges() {
        if (this.i_parentTransaction != null) {
            this.i_parentTransaction.commit5writeClassIndexChanges();
        }
        if (this._dirtyBTrees != null) {
            this._dirtyBTrees.traverse(new Visitor4(){

                public void visit(Object object) {
                    BTree bTree = (BTree)((TreeIntObject)object)._object;
                    bTree.commit(Transaction.this);
                }
            });
        }
    }

    private void commit6WriteChanges() {
        int n = this.countSlotChanges();
        if (n > 0) {
            int n2 = (n * 3 + 2) * 4;
            int n3 = this.i_file.getSlot(n2);
            YapWriter yapWriter = new YapWriter(this, n3, n2);
            yapWriter.writeInt(n2);
            yapWriter.writeInt(n);
            this.appendSlotChanges(yapWriter);
            yapWriter.write();
            this.flushFile();
            this.i_stream.writeTransactionPointer(n3);
            this.flushFile();
            if (this.writeSlots()) {
                this.flushFile();
            }
            this.i_stream.writeTransactionPointer(0);
            this.flushFile();
            this.i_file.free(n3, n2);
        }
    }

    private void commit7ClearAll() {
        if (this.i_parentTransaction != null) {
            this.i_parentTransaction.commit7ClearAll();
        }
        this.clearAll();
    }

    void commitTransactionListeners() {
        if (this.i_transactionListeners != null) {
            Iterator4Impl iterator4Impl = new Iterator4Impl(this.i_transactionListeners);
            while (iterator4Impl.hasNext()) {
                ((TransactionListener)iterator4Impl.next()).preCommit();
            }
            this.i_transactionListeners = null;
        }
    }

    private int countSlotChanges() {
        int n = 0;
        if (this.i_parentTransaction != null) {
            n += this.i_parentTransaction.countSlotChanges();
        }
        final int[] nArray = new int[]{n};
        if (this._slotChanges != null) {
            this._slotChanges.traverse(new Visitor4(){

                public void visit(Object object) {
                    SlotChange slotChange = (SlotChange)object;
                    if (slotChange.isSetPointer()) {
                        nArray[0] = nArray[0] + 1;
                    }
                }
            });
        }
        return nArray[0];
    }

    private final Tree createClassIndexNode(Tree tree, Tree[] treeArray) {
        if (tree != null) {
            Tree tree2 = tree.find(treeArray[0]);
            if (tree2 != null) {
                treeArray[0] = tree2;
            } else {
                tree = tree.add(treeArray[0]);
            }
        } else {
            tree = treeArray[0];
        }
        return tree;
    }

    void delete(YapObject yapObject, int n) {
        int n2 = yapObject.getID();
        DeleteInfo deleteInfo = (DeleteInfo)TreeInt.find(this.i_delete, n2);
        if (deleteInfo == null) {
            deleteInfo = new DeleteInfo(n2, yapObject, true, n);
            this.i_delete = Tree.add(this.i_delete, deleteInfo);
            return;
        }
        deleteInfo._reference = yapObject;
        if (n > deleteInfo._cascade) {
            deleteInfo._cascade = n;
        }
    }

    public void dirtyBTree(BTree bTree) {
        this._dirtyBTrees = Tree.add(this._dirtyBTrees, new TreeIntObject(bTree.getID(), bTree));
    }

    void dontDelete(int n, int n2) {
        DeleteInfo deleteInfo = (DeleteInfo)TreeInt.find(this.i_delete, n2);
        if (deleteInfo == null) {
            this.i_delete = Tree.add(this.i_delete, new DeleteInfo(n2, null, false, 0));
        } else {
            deleteInfo._delete = false;
        }
        YapClass yapClass = this.i_stream.getYapClass(n);
        this.dontDeleteAllAncestors(yapClass, n2);
    }

    void dontDeleteAllAncestors(YapClass yapClass, int n) {
        if (yapClass == null) {
            return;
        }
        this.removeFromClassIndexTree(this.i_removeFromClassIndex, yapClass.getID(), n);
        this.dontDeleteAllAncestors(yapClass.i_ancestor, n);
    }

    void dontRemoveFromClassIndex(int n, int n2) {
        this.removeFromClassIndexTree(this.i_removeFromClassIndex, n, n2);
        YapClass yapClass = this.i_stream.getYapClass(n);
        if (TreeInt.find((Tree)yapClass.getIndexRoot(), n2) == null) {
            this.addToClassIndex(n, n2);
        }
    }

    private final SlotChange findSlotChange(int n) {
        return (SlotChange)TreeInt.find(this._slotChanges, n);
    }

    private void flushFile() {
        if (this.i_file.i_config.flushFileBuffers()) {
            this.i_file.syncFiles();
        }
    }

    private final void freeOnCommit() {
        if (this.i_parentTransaction != null) {
            this.i_parentTransaction.freeOnCommit();
        }
        if (this._slotChanges != null) {
            this._slotChanges.traverse(new Visitor4(){

                public void visit(Object object) {
                    ((SlotChange)object).freeDuringCommit(Transaction.this.i_file);
                }
            });
        }
    }

    public Slot getSlotInformation(int n) {
        Slot slot;
        if (n == 0) {
            return null;
        }
        SlotChange slotChange = this.findSlotChange(n);
        if (slotChange != null && slotChange.isSetPointer()) {
            return slotChange.newSlot();
        }
        if (this.i_parentTransaction != null && (slot = this.i_parentTransaction.getSlotInformation(n)) != null) {
            return slot;
        }
        this.i_file.readBytes(this._pointerBuffer, n, 8);
        int n2 = this._pointerBuffer[3] & 0xFF | (this._pointerBuffer[2] & 0xFF) << 8 | (this._pointerBuffer[1] & 0xFF) << 16 | this._pointerBuffer[0] << 24;
        int n3 = this._pointerBuffer[7] & 0xFF | (this._pointerBuffer[6] & 0xFF) << 8 | (this._pointerBuffer[5] & 0xFF) << 16 | this._pointerBuffer[4] << 24;
        return new Slot(n2, n3);
    }

    boolean isDeleted(int n) {
        SlotChange slotChange = this.findSlotChange(n);
        if (slotChange != null) {
            return slotChange.isDeleted();
        }
        if (this.i_parentTransaction != null) {
            return this.i_parentTransaction.isDeleted(n);
        }
        return false;
    }

    Object[] objectAndYapObjectBySignature(long l, final byte[] byArray) {
        final Object[] objectArray = new Object[2];
        IxTraverser ixTraverser = new IxTraverser();
        IxTree ixTree = (IxTree)this.i_stream.i_handlers.i_indexes.i_fieldUUID.getIndexRoot(this);
        int n = ixTraverser.findBoundsExactMatch(new Long(l), ixTree);
        if (n > 0) {
            final Transaction transaction = this;
            ixTraverser.visitAll(new Visitor4(){

                public void visit(Object object) {
                    Object[] objectArray2 = transaction.i_stream.getObjectAndYapObjectByID(transaction, (Integer)object);
                    if (objectArray2[1] != null) {
                        YapObject yapObject = (YapObject)objectArray2[1];
                        VirtualAttributes virtualAttributes = yapObject.virtualAttributes(transaction);
                        byte[] byArray2 = virtualAttributes.i_database.i_signature;
                        boolean bl = true;
                        if (byArray.length == byArray2.length) {
                            for (int i = 0; i < byArray.length; ++i) {
                                if (byArray[i] == byArray2[i]) continue;
                                bl = false;
                                break;
                            }
                        } else {
                            bl = false;
                        }
                        if (bl) {
                            objectArray[0] = objectArray2[0];
                            objectArray[1] = objectArray2[1];
                        }
                    }
                }
            });
        }
        return objectArray;
    }

    private SlotChange produceSlotChange(int n) {
        SlotChange slotChange = new SlotChange(n);
        this._slotChanges = Tree.add(this._slotChanges, slotChange);
        return (SlotChange)slotChange.duplicateOrThis();
    }

    Reflector reflector() {
        return this.i_stream.reflector();
    }

    void removeFromClassIndex(int n, int n2) {
        this.removeFromClassIndexTree(this.i_addToClassIndex, n, n2);
        this.i_removeFromClassIndex = this.addToClassIndexTree(this.i_removeFromClassIndex, n, n2);
    }

    private final void removeFromClassIndexTree(Tree tree, int n, int n2) {
        TreeIntObject treeIntObject;
        if (tree != null && (treeIntObject = (TreeIntObject)((TreeInt)tree).find(n)) != null) {
            treeIntObject._object = Tree.removeLike((Tree)treeIntObject._object, new TreeInt(n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        Object object = this.i_stream.i_lock;
        synchronized (object) {
            this.beginEndSet();
            if (this._dirtyBTrees != null) {
                this._dirtyBTrees.traverse(new Visitor4(){

                    public void visit(Object object) {
                        BTree bTree = (BTree)((TreeIntObject)object)._object;
                        bTree.rollback(Transaction.this);
                    }
                });
            }
            if (this.i_dirtyFieldIndexes != null) {
                Iterator4Impl iterator4Impl = new Iterator4Impl(this.i_dirtyFieldIndexes);
                while (iterator4Impl.hasNext()) {
                    ((IndexTransaction)iterator4Impl.next()).rollback();
                }
            }
            if (this._slotChanges != null) {
                this._slotChanges.traverse(new Visitor4(){

                    public void visit(Object object) {
                        ((SlotChange)object).rollback(Transaction.this.i_file);
                    }
                });
            }
            this.rollBackTransactionListeners();
            this.clearAll();
        }
    }

    void rollBackTransactionListeners() {
        if (this.i_transactionListeners != null) {
            Iterator4Impl iterator4Impl = new Iterator4Impl(this.i_transactionListeners);
            while (iterator4Impl.hasNext()) {
                ((TransactionListener)iterator4Impl.next()).postRollback();
            }
            this.i_transactionListeners = null;
        }
    }

    void setAddress(int n) {
        this.i_address = n;
    }

    public void setPointer(int n, int n2, int n3) {
        this.produceSlotChange(n).setPointer(n2, n3);
    }

    void slotDelete(int n, int n2, int n3) {
        if (n == 0) {
            return;
        }
        SlotChange slotChange = this.produceSlotChange(n);
        slotChange.freeOnCommit(this.i_file, new Slot(n2, n3));
        slotChange.setPointer(0, 0);
    }

    public void slotFreeOnCommit(int n, int n2, int n3) {
        if (n == 0) {
            return;
        }
        this.produceSlotChange(n).freeOnCommit(this.i_file, new Slot(n2, n3));
    }

    void slotFreeOnRollback(int n, int n2, int n3) {
        this.produceSlotChange(n).freeOnRollback(n2, n3);
    }

    void slotFreeOnRollbackCommitSetPointer(int n, int n2, int n3) {
        Slot slot = this.getSlotInformation(n);
        SlotChange slotChange = this.produceSlotChange(n);
        slotChange.freeOnRollbackSetPointer(n2, n3);
        slotChange.freeOnCommit(this.i_file, slot);
    }

    void slotFreeOnRollbackSetPointer(int n, int n2, int n3) {
        this.produceSlotChange(n).freeOnRollbackSetPointer(n2, n3);
    }

    public void slotFreePointerOnCommit(int n) {
        Slot slot = this.getSlotInformation(n);
        if (slot == null) {
            return;
        }
        this.slotFreeOnCommit(n, slot._address, slot._length);
    }

    void slotFreePointerOnCommit(int n, int n2, int n3) {
        this.slotFreeOnCommit(n2, n2, n3);
        this.slotFreeOnCommit(n, n, 8);
    }

    boolean supportsVirtualFields() {
        return true;
    }

    public Transaction systemTransaction() {
        if (this.i_parentTransaction != null) {
            return this.i_parentTransaction;
        }
        return this;
    }

    public String toString() {
        return this.i_stream.toString();
    }

    void traverseAddedClassIDs(int n, Visitor4 visitor4) {
        this.traverseDeep(this.i_addToClassIndex, n, visitor4);
    }

    void traverseDeep(Tree tree, int n, Visitor4 visitor4) {
        TreeIntObject treeIntObject;
        if (tree != null && (treeIntObject = (TreeIntObject)((TreeInt)tree).find(n)) != null && treeIntObject._object != null) {
            ((Tree)treeIntObject._object).traverse(visitor4);
        }
    }

    void traverseRemovedClassIDs(int n, Visitor4 visitor4) {
        this.traverseDeep(this.i_removeFromClassIndex, n, visitor4);
    }

    private void traverseYapClassEntries(Tree tree, boolean bl, Collection4 collection4) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeOld() {
        Object object = this.i_stream.i_lock;
        synchronized (object) {
            this.i_pointerIo.useSlot(this.i_address);
            this.i_pointerIo.read();
            int n = this.i_pointerIo.readInt();
            if (n > 0) {
                YapWriter yapWriter = new YapWriter(this, this.i_address, n);
                yapWriter.read();
                yapWriter.incrementOffset(4);
                this._slotChanges = new TreeReader(yapWriter, new SlotChange(0)).read();
                if (this.writeSlots()) {
                    this.flushFile();
                }
                this.i_stream.writeTransactionPointer(0);
                this.flushFile();
                this.freeOnCommit();
            } else {
                this.i_stream.writeTransactionPointer(0);
                this.flushFile();
            }
        }
    }

    public void writePointer(int n, int n2, int n3) {
        this.i_pointerIo.useSlot(n);
        this.i_pointerIo.writeInt(n2);
        this.i_pointerIo.writeInt(n3);
        this.i_pointerIo.write();
    }

    private boolean writeSlots() {
        boolean bl = false;
        if (this.i_parentTransaction != null && this.i_parentTransaction.writeSlots()) {
            bl = true;
        }
        if (this._slotChanges != null) {
            this._slotChanges.traverse(new Visitor4(){

                public void visit(Object object) {
                    ((SlotChange)object).writePointer(Transaction.this);
                }
            });
            bl = true;
        }
        return bl;
    }

    void writeUpdateDeleteMembers(int n, YapClass yapClass, int n2, int n3) {
        if (Tree.find(this.i_writtenUpdateDeletedMembers, new TreeInt(n)) != null) {
            return;
        }
        this.i_writtenUpdateDeletedMembers = Tree.add(this.i_writtenUpdateDeletedMembers, new TreeInt(n));
        YapWriter yapWriter = this.i_stream.readWriterByID(this, n);
        if (yapWriter == null) {
            if (yapClass.hasIndex()) {
                this.dontRemoveFromClassIndex(yapClass.getID(), n);
            }
            return;
        }
        ObjectHeader objectHeader = new ObjectHeader(this.i_stream, yapClass, yapWriter);
        DeleteInfo deleteInfo = (DeleteInfo)TreeInt.find(this.i_delete, n);
        if (deleteInfo != null && deleteInfo._cascade > n3) {
            n3 = deleteInfo._cascade;
        }
        yapWriter.setCascadeDeletes(n3);
        yapClass.deleteMembers(objectHeader._marshallerFamily, objectHeader._headerAttributes, yapWriter, n2, true);
        this.slotFreeOnCommit(n, yapWriter.getAddress(), yapWriter.getLength());
    }
}

