/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.nativequery.optimization;

import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.file.ClassSource;
import com.db4o.instrumentation.bloat.BloatTypeEditor;
import com.db4o.instrumentation.core.BloatLoaderContext;
import com.db4o.nativequery.analysis.BloatExprBuilderVisitor;
import com.db4o.nativequery.expr.Expression;
import com.db4o.nativequery.instrumentation.SODAMethodBuilder;

public class NativeQueryEnhancer {
    public boolean enhance(BloatLoaderContext bloatUtil, ClassEditor classEditor, String methodName, Type[] argTypes, ClassLoader classLoader, ClassSource classSource) throws Exception {
        Expression expr = this.analyze(bloatUtil, classEditor, methodName, argTypes);
        if (expr == null) {
            return false;
        }
        new SODAMethodBuilder(new BloatTypeEditor(classEditor, bloatUtil.references())).injectOptimization(expr);
        classEditor.commit();
        return true;
    }

    public Expression analyze(BloatLoaderContext bloatUtil, ClassEditor classEditor, String methodName) {
        return this.analyze(bloatUtil, classEditor, methodName, null);
    }

    public Expression analyze(BloatLoaderContext bloatUtil, ClassEditor classEditor, String methodName, Type[] argTypes) {
        FlowGraph flowGraph = null;
        try {
            flowGraph = bloatUtil.flowGraph(classEditor, methodName, argTypes);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        if (flowGraph != null) {
            BloatExprBuilderVisitor builder = new BloatExprBuilderVisitor(bloatUtil);
            flowGraph.visit(builder);
            Expression expr = builder.expression();
            return expr;
        }
        return null;
    }
}

