/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.nativequery.analysis;

import EDU.purdue.cs.bloat.editor.Type;
import com.db4o.instrumentation.api.TypeRef;
import com.db4o.instrumentation.util.BloatUtil;
import com.db4o.nativequery.expr.cmp.operand.FieldValue;
import java.util.Arrays;
import java.util.Date;

public class TypeRefUtil {
    private static final String[] PRIMITIVE_WRAPPER_NAMES = new String[]{Boolean.class.getName(), Byte.class.getName(), Short.class.getName(), Character.class.getName(), Integer.class.getName(), Long.class.getName(), Double.class.getName(), Float.class.getName(), String.class.getName(), Date.class.getName()};

    public static boolean isPrimitiveWrapper(Type type) {
        return Arrays.binarySearch(PRIMITIVE_WRAPPER_NAMES, BloatUtil.normalizeClassName(type)) >= 0;
    }

    public static boolean isPrimitiveWrapper(TypeRef type) {
        return Arrays.binarySearch(PRIMITIVE_WRAPPER_NAMES, BloatUtil.normalizeClassName(type.name())) >= 0;
    }

    public static boolean isPrimitiveBoolean(TypeRef fieldType) {
        return TypeRefUtil.isType(fieldType, Boolean.TYPE);
    }

    public static boolean isBooleanField(FieldValue fieldVal) {
        TypeRef type = fieldVal.field().type();
        return TypeRefUtil.isPrimitiveBoolean(type) || TypeRefUtil.isType(type, Boolean.class);
    }

    private static boolean isType(TypeRef fieldType, Class type) {
        return fieldType.name().equals(type.getName());
    }

    static {
        Arrays.sort(PRIMITIVE_WRAPPER_NAMES);
    }
}

