/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.nativequery.analysis;

import EDU.purdue.cs.bloat.cfg.Block;
import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.tree.ArithExpr;
import EDU.purdue.cs.bloat.tree.ArrayRefExpr;
import EDU.purdue.cs.bloat.tree.CallExpr;
import EDU.purdue.cs.bloat.tree.CallMethodExpr;
import EDU.purdue.cs.bloat.tree.CallStaticExpr;
import EDU.purdue.cs.bloat.tree.ConstantExpr;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.ExprStmt;
import EDU.purdue.cs.bloat.tree.FieldExpr;
import EDU.purdue.cs.bloat.tree.IfCmpStmt;
import EDU.purdue.cs.bloat.tree.IfStmt;
import EDU.purdue.cs.bloat.tree.IfZeroStmt;
import EDU.purdue.cs.bloat.tree.LocalExpr;
import EDU.purdue.cs.bloat.tree.Node;
import EDU.purdue.cs.bloat.tree.ReturnExprStmt;
import EDU.purdue.cs.bloat.tree.StackExpr;
import EDU.purdue.cs.bloat.tree.StaticFieldExpr;
import EDU.purdue.cs.bloat.tree.StoreExpr;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import com.db4o.activation.ActivationPurpose;
import com.db4o.instrumentation.api.CallingConvention;
import com.db4o.instrumentation.api.FieldRef;
import com.db4o.instrumentation.api.MethodRef;
import com.db4o.instrumentation.api.TypeRef;
import com.db4o.instrumentation.bloat.BloatReferenceProvider;
import com.db4o.instrumentation.core.BloatLoaderContext;
import com.db4o.instrumentation.util.BloatUtil;
import com.db4o.nativequery.analysis.ComparisonExpressionFactory;
import com.db4o.nativequery.analysis.OpSymmetryUtil;
import com.db4o.nativequery.analysis.TypeRefUtil;
import com.db4o.nativequery.expr.BoolConstExpression;
import com.db4o.nativequery.expr.ComparisonExpression;
import com.db4o.nativequery.expr.Expression;
import com.db4o.nativequery.expr.ExpressionPart;
import com.db4o.nativequery.expr.IgnoredExpression;
import com.db4o.nativequery.expr.TraversingExpressionVisitor;
import com.db4o.nativequery.expr.build.ExpressionBuilder;
import com.db4o.nativequery.expr.cmp.ArithmeticOperator;
import com.db4o.nativequery.expr.cmp.ComparisonOperator;
import com.db4o.nativequery.expr.cmp.operand.ArithmeticExpression;
import com.db4o.nativequery.expr.cmp.operand.ArrayAccessValue;
import com.db4o.nativequery.expr.cmp.operand.CandidateFieldRoot;
import com.db4o.nativequery.expr.cmp.operand.ComparisonOperand;
import com.db4o.nativequery.expr.cmp.operand.ComparisonOperandAnchor;
import com.db4o.nativequery.expr.cmp.operand.ComparisonOperandDescendant;
import com.db4o.nativequery.expr.cmp.operand.ConstValue;
import com.db4o.nativequery.expr.cmp.operand.FieldValue;
import com.db4o.nativequery.expr.cmp.operand.MethodCallValue;
import com.db4o.nativequery.expr.cmp.operand.PredicateFieldRoot;
import com.db4o.nativequery.expr.cmp.operand.StaticFieldRoot;
import com.db4o.nativequery.expr.cmp.operand.ThreeWayComparison;
import com.db4o.ta.Activatable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BloatExprBuilderVisitor
extends TreeVisitor {
    private static final int MAX_DEPTH = 10;
    private static final ExpressionBuilder EXP_BUILDER = new ExpressionBuilder();
    private static final ComparisonExpressionFactory CMP_BUILDER = new ComparisonExpressionFactory(EXP_BUILDER);
    private final Map<Block, ExpressionPart> _seenBlocks = new HashMap<Block, ExpressionPart>();
    private final BloatLoaderContext _context;
    private final LinkedList<MemberRef> _methodStack;
    private final List<ComparisonOperand> _locals;
    private Expression _expr;
    private ExpressionPart _retval;
    private int _retCount = 0;
    private int _blockCount = 0;
    private int _topLevelStmtCount = 0;

    public BloatExprBuilderVisitor(BloatLoaderContext bloatUtil) {
        this(bloatUtil, new LinkedList<MemberRef>(), Arrays.asList(PredicateFieldRoot.INSTANCE, CandidateFieldRoot.INSTANCE));
    }

    private BloatExprBuilderVisitor(BloatLoaderContext bloatUtil, LinkedList<MemberRef> methodStack, List<ComparisonOperand> locals) {
        this._context = bloatUtil;
        this._methodStack = methodStack;
        this._locals = locals;
    }

    private ExpressionPart purgeReturnValue() {
        ExpressionPart expr = this._retval;
        this.retval(null);
        return expr;
    }

    private void expression(Expression expr) {
        this.retval(expr);
        this._expr = expr;
    }

    private void retval(ExpressionPart expr) {
        this._retval = expr;
    }

    public Expression expression() {
        if (this._expr == null && this.isSingleReturn() && this._retval instanceof ConstValue) {
            this.expression(this.asExpression(this._retval));
        }
        if (this._expr == BoolConstExpression.FALSE) {
            return null;
        }
        return this.checkComparisons(this._expr) ? this._expr : null;
    }

    public ExpressionPart returnValue() {
        return this.purgeReturnValue();
    }

    private boolean isSingleReturn() {
        return this._retCount == 1 && this._blockCount == 4;
    }

    private boolean checkComparisons(Expression expr) {
        if (expr == null) {
            return true;
        }
        final boolean[] result = new boolean[]{true};
        expr.accept(new TraversingExpressionVisitor(){

            public void visit(ComparisonExpression expression) {
                if (expression.left().root() != CandidateFieldRoot.INSTANCE) {
                    result[0] = false;
                }
            }
        });
        return result[0];
    }

    @Override
    public void visitIfZeroStmt(IfZeroStmt stmt) {
        this.enterStatement();
        Object retval = this.descend(stmt.expr());
        this.exitStatement();
        boolean cmpNull = false;
        if (retval instanceof FieldValue) {
            Expression forced = this.identityOrBoolComparisonOrNull(retval);
            if (forced != null) {
                retval = forced;
            } else {
                FieldValue fieldVal = (FieldValue)retval;
                Integer constVal = null;
                if (fieldVal.field().type().isPrimitive()) {
                    constVal = new Integer(0);
                }
                retval = BloatExprBuilderVisitor.comparisonExpression(fieldVal, new ConstValue(constVal), ComparisonOperator.VALUE_EQUALITY);
                cmpNull = true;
            }
        }
        if (retval instanceof Expression) {
            Expression expr = (Expression)retval;
            if (stmt.comparison() == 0 && !cmpNull || stmt.comparison() == 1 && cmpNull) {
                expr = EXP_BUILDER.not(expr);
            }
            this.expression(this.buildComparison(stmt, expr));
            return;
        }
        if (!(retval instanceof ThreeWayComparison)) {
            throw new EarlyExitException();
        }
        ThreeWayComparison cmp = (ThreeWayComparison)retval;
        Expression expr = null;
        int comparison = stmt.comparison();
        if (cmp.swapped()) {
            comparison = OpSymmetryUtil.counterpart(comparison);
        }
        switch (comparison) {
            case 0: {
                expr = BloatExprBuilderVisitor.comparisonExpression(cmp.left(), cmp.right(), ComparisonOperator.VALUE_EQUALITY);
                break;
            }
            case 1: {
                expr = EXP_BUILDER.not(BloatExprBuilderVisitor.comparisonExpression(cmp.left(), cmp.right(), ComparisonOperator.VALUE_EQUALITY));
                break;
            }
            case 4: {
                expr = BloatExprBuilderVisitor.comparisonExpression(cmp.left(), cmp.right(), ComparisonOperator.SMALLER);
                break;
            }
            case 2: {
                expr = BloatExprBuilderVisitor.comparisonExpression(cmp.left(), cmp.right(), ComparisonOperator.GREATER);
                break;
            }
            case 5: {
                expr = EXP_BUILDER.not(BloatExprBuilderVisitor.comparisonExpression(cmp.left(), cmp.right(), ComparisonOperator.GREATER));
                break;
            }
            case 3: {
                expr = EXP_BUILDER.not(BloatExprBuilderVisitor.comparisonExpression(cmp.left(), cmp.right(), ComparisonOperator.SMALLER));
                break;
            }
        }
        this.expression(this.buildComparison(stmt, expr));
    }

    private void exitStatement() {
        if (this._topLevelStmtCount > 1 && this._retval != IgnoredExpression.INSTANCE) {
            throw new EarlyExitException();
        }
        if (this._retval == IgnoredExpression.INSTANCE) {
            --this._topLevelStmtCount;
        }
    }

    private void enterStatement() {
        ++this._topLevelStmtCount;
    }

    @Override
    public void visitIfCmpStmt(IfCmpStmt stmt) {
        FieldValue rightField;
        this.enterStatement();
        Object left = this.descend(stmt.left());
        Object right = this.descend(stmt.right());
        this.exitStatement();
        int op = stmt.comparison();
        if (left instanceof ComparisonOperand && right instanceof FieldValue && (rightField = (FieldValue)right).root() == CandidateFieldRoot.INSTANCE) {
            Object swap = left;
            left = right;
            right = swap;
            op = OpSymmetryUtil.counterpart(op);
        }
        if (!(left instanceof FieldValue) || !(right instanceof ComparisonOperand)) {
            throw new EarlyExitException();
        }
        FieldValue fieldExpr = (FieldValue)left;
        ComparisonOperand valueExpr = (ComparisonOperand)right;
        boolean isPrimitive = this.isPrimitiveExpr(stmt.left());
        Expression cmp = this.buildComparison(stmt, CMP_BUILDER.buildComparison(op, isPrimitive, fieldExpr, valueExpr));
        this.expression(cmp);
    }

    @Override
    public void visitExprStmt(ExprStmt stmt) {
        this.enterStatement();
        super.visitExprStmt(stmt);
        this.exitStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitCallExpr(CallExpr expr) {
        block19: {
            boolean isStatic = expr instanceof CallStaticExpr;
            if (!isStatic && expr.method().name().equals("<init>")) {
                throw new EarlyExitException();
            }
            if (!isStatic && expr.method().name().equals("equals")) {
                CallMethodExpr call = (CallMethodExpr)expr;
                if (TypeRefUtil.isPrimitiveWrapper(call.receiver().type())) {
                    this.processEqualsCall(call, ComparisonOperator.VALUE_EQUALITY);
                }
                return;
            }
            if (!isStatic && this.isActivateMethod(expr.method())) {
                this.retval(IgnoredExpression.INSTANCE);
                return;
            }
            if (expr.method().declaringClass().equals(Type.STRING)) {
                if (this.applyStringHandling(expr)) {
                    return;
                }
                throw new EarlyExitException();
            }
            if (this.isCollectionClass(expr.method().declaringClass()) && this.applyCollectionHandling(expr)) {
                return;
            }
            ComparisonOperandAnchor receiver = null;
            if (!isStatic) {
                receiver = (ComparisonOperandAnchor)this.descend(((CallMethodExpr)expr).receiver());
            }
            if (TypeRefUtil.isPrimitiveWrapper(expr.method().declaringClass()) && this.applyPrimitiveWrapperHandling(expr, receiver)) {
                return;
            }
            MemberRef methodRef = expr.method();
            if (this._methodStack.contains(methodRef) || this._methodStack.size() > 10) {
                throw new EarlyExitException();
            }
            this._methodStack.addLast(methodRef);
            try {
                List<ComparisonOperand> params = this.collectMethodParams(expr, receiver);
                if (this.handledAsSafeMethod(expr, receiver, params)) {
                    return;
                }
                ExpressionPart methodRetval = this.descendIntoMethodCall(expr, params);
                if (methodRetval == null) {
                    throw new EarlyExitException();
                }
                if (methodRetval != IgnoredExpression.INSTANCE && this.containsCandidateAsParam(params)) {
                    throw new EarlyExitException();
                }
                this.retval(methodRetval);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            finally {
                MemberRef last = this._methodStack.removeLast();
                if (((Object)last).equals(methodRef)) break block19;
                throw new RuntimeException("method stack inconsistent: push=" + methodRef + " , pop=" + last);
            }
        }
    }

    private ExpressionPart descendIntoMethodCall(CallExpr expr, List<ComparisonOperand> params) throws ClassNotFoundException {
        Type declaringClass = this.detectDeclaringClass(expr);
        MemberRef methodRef = expr.method();
        FlowGraph flowGraph = this._context.flowGraph(declaringClass.className(), methodRef.name(), methodRef.type().paramTypes());
        if (flowGraph == null) {
            throw new EarlyExitException();
        }
        BloatExprBuilderVisitor visitor = new BloatExprBuilderVisitor(this._context, this._methodStack, params);
        flowGraph.visit(visitor);
        return visitor.returnValue();
    }

    private boolean containsCandidateAsParam(List<ComparisonOperand> params) {
        for (ComparisonOperand param : this.excludeReceiverParam(params)) {
            if (!(param instanceof ComparisonOperandAnchor) || ((ComparisonOperandAnchor)param).root() != CandidateFieldRoot.INSTANCE) continue;
            return true;
        }
        return false;
    }

    private List<ComparisonOperand> excludeReceiverParam(List<ComparisonOperand> params) {
        return params.subList(1, params.size());
    }

    private Type detectDeclaringClass(CallExpr expr) throws ClassNotFoundException {
        Expr receiverExpr;
        Type receiverType;
        Type declaringClass = expr.method().declaringClass();
        if (expr instanceof CallMethodExpr && this.isSuperType(declaringClass, receiverType = (receiverExpr = ((CallMethodExpr)expr).receiver()).type())) {
            declaringClass = receiverType;
        }
        return declaringClass;
    }

    private List<ComparisonOperand> collectMethodParams(CallExpr expr, ComparisonOperandAnchor receiver) {
        ArrayList<ComparisonOperand> params = new ArrayList<ComparisonOperand>(expr.params().length + 1);
        params.add(receiver);
        for (int idx = 0; idx < expr.params().length; ++idx) {
            ComparisonOperand curparam = (ComparisonOperand)this.descend(expr.params()[idx]);
            params.add(curparam);
        }
        return params;
    }

    private boolean handledAsSafeMethod(CallExpr expr, ComparisonOperandAnchor rcvRetval, List<ComparisonOperand> params) {
        if (!this.isSafe(rcvRetval)) {
            return false;
        }
        for (ComparisonOperand param : params) {
            if (this.isSafe(param)) continue;
            return false;
        }
        if (rcvRetval == null) {
            rcvRetval = new StaticFieldRoot(this.typeRef(expr.method().declaringClass()));
        }
        params.remove(0);
        this.retval(new MethodCallValue(this.methodRef(expr.method()), this.callingConvention(expr), rcvRetval, params.toArray(new ComparisonOperand[params.size()])));
        return true;
    }

    private boolean isSafe(ComparisonOperand op) {
        if (!(op instanceof ComparisonOperandAnchor)) {
            return true;
        }
        ComparisonOperandAnchor anchor = (ComparisonOperandAnchor)op;
        if (anchor.root() == CandidateFieldRoot.INSTANCE) {
            return false;
        }
        if (!(anchor instanceof MethodCallValue)) {
            return true;
        }
        MethodCallValue call = (MethodCallValue)anchor;
        for (ComparisonOperand arg : call.args()) {
            if (this.isSafe(arg)) continue;
            return false;
        }
        return true;
    }

    private boolean isActivateMethod(MemberRef method) {
        if (!method.name().equals("activate")) {
            return false;
        }
        Type[] params = method.type().paramTypes();
        if (params.length != 1) {
            return false;
        }
        if (!ActivationPurpose.class.getName().equals(BloatUtil.normalizeClassName(params[0]))) {
            return false;
        }
        try {
            ClassEditor activateClazz = this._context.classEditor(method.declaringClass());
            return BloatUtil.implementsInHierarchy(activateClazz, Activatable.class, this._context);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    private CallingConvention callingConvention(CallExpr expr) {
        if (expr instanceof CallStaticExpr) {
            return CallingConvention.STATIC;
        }
        CallMethodExpr cme = (CallMethodExpr)expr;
        if (cme.kind() == 2) {
            return CallingConvention.INTERFACE;
        }
        return CallingConvention.VIRTUAL;
    }

    private MethodRef methodRef(MemberRef method) {
        return this.references().forBloatMethod(method);
    }

    private boolean isSuperType(Type declaringClass, Type receiverType) throws ClassNotFoundException {
        if (declaringClass.className().equals(receiverType.className())) {
            return false;
        }
        ClassEditor receiverEditor = this._context.classEditor(receiverType.className());
        Type superClass = receiverEditor.superclass();
        if (superClass != null) {
            if (superClass.className().equals(declaringClass.className())) {
                return true;
            }
            if (this.isSuperType(declaringClass, superClass)) {
                return true;
            }
        }
        Type[] interfaces = receiverEditor.interfaces();
        for (int interfaceIdx = 0; interfaceIdx < interfaces.length; ++interfaceIdx) {
            if (interfaces[interfaceIdx].className().equals(declaringClass.className())) {
                return true;
            }
            if (!this.isSuperType(declaringClass, interfaces[interfaceIdx])) continue;
            return true;
        }
        return false;
    }

    private boolean applyPrimitiveWrapperHandling(CallExpr expr, ComparisonOperandAnchor rcvRetval) {
        String methodName = expr.method().name();
        if (methodName.endsWith("Value")) {
            return this.handlePrimitiveWrapperValueCall(rcvRetval);
        }
        if (methodName.equals("compareTo")) {
            return this.handlePrimitiveWrapperCompareToCall(expr, rcvRetval);
        }
        return false;
    }

    private boolean handlePrimitiveWrapperCompareToCall(CallExpr expr, ComparisonOperandAnchor receiver) {
        ComparisonOperandAnchor left = receiver;
        ComparisonOperand right = (ComparisonOperand)this.descend(expr.params()[0]);
        this.retval(new ThreeWayComparison((FieldValue)left, right, false));
        return true;
    }

    private boolean handlePrimitiveWrapperValueCall(ComparisonOperandAnchor rcvRetval) {
        this.retval(rcvRetval);
        if (rcvRetval instanceof FieldValue) {
            FieldValue fieldval = (FieldValue)rcvRetval;
            if (TypeRefUtil.isBooleanField(fieldval)) {
                this.retval(BloatExprBuilderVisitor.comparisonExpression(fieldval, new ConstValue(Boolean.TRUE), ComparisonOperator.VALUE_EQUALITY, true));
            }
            if (fieldval.root().equals(CandidateFieldRoot.INSTANCE)) {
                return true;
            }
        }
        return false;
    }

    private boolean applyStringHandling(CallExpr expr) {
        if (expr.method().name().equals("contains")) {
            this.processEqualsCall((CallMethodExpr)expr, ComparisonOperator.CONTAINS);
            return true;
        }
        if (expr.method().name().equals("startsWith")) {
            this.processEqualsCall((CallMethodExpr)expr, ComparisonOperator.STARTS_WITH);
            return true;
        }
        if (expr.method().name().equals("endsWith")) {
            this.processEqualsCall((CallMethodExpr)expr, ComparisonOperator.ENDS_WITH);
            return true;
        }
        return false;
    }

    private boolean isCollectionClass(Type type) {
        try {
            ClassEditor editor = this._context.classEditor(type);
            return BloatUtil.implementsInHierarchy(editor, Collection.class, this._context) || BloatUtil.implementsInHierarchy(editor, Map.class, this._context);
        }
        catch (ClassNotFoundException exc) {
            exc.printStackTrace();
            return false;
        }
    }

    private boolean applyCollectionHandling(CallExpr expr) {
        String methodName = expr.method().name();
        if (methodName.equals("size")) {
            throw new EarlyExitException();
        }
        if (methodName.equals("isEmpty")) {
            throw new EarlyExitException();
        }
        return false;
    }

    private boolean isPrimitiveExpr(Expr expr) {
        return expr.type().isPrimitive();
    }

    private void processEqualsCall(CallMethodExpr expr, ComparisonOperator op) {
        Expr left = expr.receiver();
        Expr right = expr.params()[0];
        if (!this.isComparableExprOperand(left) || !this.isComparableExprOperand(right)) {
            throw new EarlyExitException();
        }
        Object leftObj = this.descend(left);
        if (!(leftObj instanceof ComparisonOperand)) {
            throw new EarlyExitException();
        }
        ComparisonOperand leftOp = (ComparisonOperand)leftObj;
        ComparisonOperand rightOp = (ComparisonOperand)this.descend(right);
        if (op.isSymmetric() && BloatExprBuilderVisitor.isCandidateFieldValue(rightOp) && !BloatExprBuilderVisitor.isCandidateFieldValue(leftOp)) {
            ComparisonOperand swap = leftOp;
            leftOp = rightOp;
            rightOp = swap;
        }
        if (!BloatExprBuilderVisitor.isCandidateFieldValue(leftOp) || rightOp == null) {
            throw new EarlyExitException();
        }
        this.expression(BloatExprBuilderVisitor.comparisonExpression((FieldValue)leftOp, rightOp, op));
    }

    private static boolean isCandidateFieldValue(ComparisonOperand op) {
        return op instanceof FieldValue && ((FieldValue)op).root() == CandidateFieldRoot.INSTANCE;
    }

    private boolean isComparableExprOperand(Expr expr) {
        return expr instanceof FieldExpr || expr instanceof StaticFieldExpr || expr instanceof CallMethodExpr || expr instanceof CallStaticExpr || expr instanceof ConstantExpr || expr instanceof LocalExpr;
    }

    @Override
    public void visitFieldExpr(FieldExpr expr) {
        Object fieldObj = this.descend(expr.object());
        if (fieldObj instanceof ComparisonOperandAnchor) {
            this.retval(BloatExprBuilderVisitor.fieldValue((ComparisonOperandAnchor)fieldObj, this.fieldRef(expr.field())));
        }
    }

    @Override
    public void visitStaticFieldExpr(StaticFieldExpr expr) {
        MemberRef field = expr.field();
        this.retval(BloatExprBuilderVisitor.fieldValue(new StaticFieldRoot(this.typeRef(field.declaringClass())), this.fieldRef(field)));
    }

    private FieldRef fieldRef(MemberRef field) {
        return this.references().forBloatField(field);
    }

    private TypeRef typeRef(Type type) {
        return this.references().forBloatType(type);
    }

    private BloatReferenceProvider references() {
        return this._context.references();
    }

    @Override
    public void visitConstantExpr(ConstantExpr expr) {
        super.visitConstantExpr(expr);
        this.retval(new ConstValue(expr.value()));
    }

    @Override
    public void visitLocalExpr(LocalExpr expr) {
        super.visitLocalExpr(expr);
        if (expr.index() >= this._locals.size()) {
            throw new EarlyExitException();
        }
        this.retval(this._locals.get(expr.index()));
    }

    @Override
    public void visitBlock(Block block) {
        if (this._seenBlocks.containsKey(block)) {
            this.retval(this._seenBlocks.get(block));
            return;
        }
        this._topLevelStmtCount = 0;
        super.visitBlock(block);
        this._seenBlocks.put(block, this._retval);
        ++this._blockCount;
    }

    @Override
    public void visitFlowGraph(FlowGraph graph) {
        try {
            Expression forced;
            super.visitFlowGraph(graph);
            if (this._expr == null && (forced = this.identityOrBoolComparisonOrNull(this._retval)) != null) {
                this.expression(forced);
            }
        }
        catch (EarlyExitException exc) {
            this.expression(null);
        }
    }

    private Expression identityOrBoolComparisonOrNull(Object val) {
        if (val instanceof Expression) {
            return (Expression)val;
        }
        if (!(val instanceof FieldValue)) {
            return null;
        }
        FieldValue fieldVal = (FieldValue)val;
        if (fieldVal.root() != CandidateFieldRoot.INSTANCE) {
            return null;
        }
        TypeRef fieldType = fieldVal.field().type();
        if (!fieldType.isPrimitive()) {
            return null;
        }
        if (!TypeRefUtil.isPrimitiveBoolean(fieldType)) {
            return null;
        }
        return BloatExprBuilderVisitor.comparisonExpression(fieldVal, new ConstValue(Boolean.TRUE), ComparisonOperator.VALUE_EQUALITY);
    }

    @Override
    public void visitArithExpr(ArithExpr expr) {
        ArithmeticOperator arithOp;
        FieldValue rightField;
        Object leftObj = this.descend(expr.left());
        if (!(leftObj instanceof ComparisonOperand)) {
            throw new EarlyExitException();
        }
        ComparisonOperand left = (ComparisonOperand)leftObj;
        Object rightObj = this.descend(expr.right());
        if (!(rightObj instanceof ComparisonOperand)) {
            throw new EarlyExitException();
        }
        ComparisonOperand right = (ComparisonOperand)rightObj;
        boolean swapped = false;
        if (right instanceof FieldValue && (rightField = (FieldValue)right).root() == CandidateFieldRoot.INSTANCE) {
            ComparisonOperand swap = left;
            left = right;
            right = swap;
            swapped = true;
        }
        if ((arithOp = this.arithmeticOperator(expr.operation())) != null) {
            this.retval(new ArithmeticExpression(left, right, arithOp));
            return;
        }
        switch (expr.operation()) {
            case 60: 
            case 62: 
            case 63: {
                if (!(left instanceof FieldValue)) break;
                this.retval(new ThreeWayComparison((FieldValue)left, right, swapped));
                break;
            }
            case 94: {
                if (!(left instanceof FieldValue)) break;
                this.retval(EXP_BUILDER.not(BloatExprBuilderVisitor.comparisonExpression((FieldValue)left, right, ComparisonOperator.VALUE_EQUALITY)));
                break;
            }
            default: {
                throw new EarlyExitException();
            }
        }
    }

    @Override
    public void visitArrayRefExpr(ArrayRefExpr expr) {
        ComparisonOperandDescendant arrayOp = (ComparisonOperandDescendant)this.descend(expr.array());
        ComparisonOperand idxOp = (ComparisonOperand)this.descend(expr.index());
        if (arrayOp == null || idxOp == null || arrayOp.root() == CandidateFieldRoot.INSTANCE) {
            throw new EarlyExitException();
        }
        this.retval(new ArrayAccessValue(arrayOp, idxOp));
    }

    @Override
    public void visitReturnExprStmt(ReturnExprStmt stat) {
        this.enterStatement();
        stat.expr().visit(this);
        this.exitStatement();
        ++this._retCount;
    }

    private ArithmeticOperator arithmeticOperator(int bloatOp) {
        switch (bloatOp) {
            case 43: {
                return ArithmeticOperator.ADD;
            }
            case 45: {
                return ArithmeticOperator.SUBTRACT;
            }
            case 42: {
                return ArithmeticOperator.MULTIPLY;
            }
            case 47: {
                return ArithmeticOperator.DIVIDE;
            }
            case 37: {
                return ArithmeticOperator.MODULO;
            }
        }
        return null;
    }

    private Expression buildComparison(IfStmt stmt, Expression cmp) {
        stmt.trueTarget().visit(this);
        ExpressionPart trueVal = this.purgeReturnValue();
        stmt.falseTarget().visit(this);
        ExpressionPart falseVal = this.purgeReturnValue();
        Expression trueExpr = this.asExpression(trueVal);
        Expression falseExpr = this.asExpression(falseVal);
        if (trueExpr == null || falseExpr == null) {
            return null;
        }
        return EXP_BUILDER.ifThenElse(cmp, trueExpr, falseExpr);
    }

    private Expression asExpression(Object obj) {
        int exprval;
        if (obj instanceof Expression) {
            return (Expression)obj;
        }
        if (obj instanceof ConstValue) {
            Object val = ((ConstValue)obj).value();
            return this.asExpression(val);
        }
        if (obj instanceof Boolean) {
            return BoolConstExpression.expr((Boolean)obj);
        }
        if (obj instanceof Integer && ((exprval = ((Integer)obj).intValue()) == 0 || exprval == 1)) {
            return BoolConstExpression.expr(exprval == 1);
        }
        return null;
    }

    @Override
    public void visitStoreExpr(StoreExpr expr) {
        if (!(expr.target() instanceof StackExpr)) {
            throw new EarlyExitException();
        }
        super.visitStoreExpr(expr);
    }

    private static ComparisonExpression comparisonExpression(FieldValue left, ComparisonOperand right, ComparisonOperator op) {
        return BloatExprBuilderVisitor.comparisonExpression(left, right, op, false);
    }

    private static ComparisonExpression comparisonExpression(FieldValue left, ComparisonOperand right, ComparisonOperator op, boolean lenient) {
        if (!lenient && !BloatExprBuilderVisitor.isCandidateFieldValue(left) || right == null) {
            throw new EarlyExitException();
        }
        return new ComparisonExpression(left, right, op);
    }

    private static ComparisonOperand fieldValue(ComparisonOperandAnchor parent, FieldRef field) {
        if (parent instanceof ComparisonOperandDescendant) {
            ComparisonOperandDescendant descendant = (ComparisonOperandDescendant)parent;
            if ("value".equals(field.name()) && TypeRefUtil.isPrimitiveWrapper(descendant.type())) {
                return parent;
            }
        }
        return new FieldValue(parent, field);
    }

    private <T extends ExpressionPart> T descend(Node node) {
        node.visit(this);
        return (T)this.purgeReturnValue();
    }

    private static class EarlyExitException
    extends RuntimeException {
        private EarlyExitException() {
        }
    }
}

