/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.monitoring;

import com.db4o.ObjectContainer;
import com.db4o.diagnostic.NativeQueryNotOptimized;
import com.db4o.internal.query.NQOptimizationInfo;
import com.db4o.monitoring.NativeQueriesMBean;
import com.db4o.monitoring.NotificationEmitterMBean;
import com.db4o.monitoring.internal.TimedReading;
import com.db4o.query.Predicate;
import javax.management.JMException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeQueries
extends NotificationEmitterMBean
implements NativeQueriesMBean {
    private final TimedReading _nativeQueries = TimedReading.newPerSecond();
    private final TimedReading _unoptimizedNativeQueries = TimedReading.newPerSecond();

    public NativeQueries(ObjectContainer db, Class<?> type) throws JMException {
        super(db, type);
    }

    @Override
    public double getUnoptimizedNativeQueriesPerSecond() {
        return this._unoptimizedNativeQueries.read();
    }

    @Override
    public double getNativeQueriesPerSecond() {
        return this._nativeQueries.read();
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{this.unoptimizedQueryNotificationType()}, Notification.class.getName(), "Notification about unoptimized native query execution.")};
    }

    private String unoptimizedQueryNotificationType() {
        return NativeQueryNotOptimized.class.getName();
    }

    public void notifyNativeQuery(NQOptimizationInfo info) {
        if (info.message().equals("UNOPTIMIZED")) {
            this.notifyUnoptimized(info.predicate());
        }
        this._nativeQueries.increment();
    }

    private void notifyUnoptimized(Predicate predicate) {
        this._unoptimizedNativeQueries.increment();
        this.sendNotification(this.unoptimizedQueryNotificationType(), "Unoptimized native query.", predicate.getClass().getName());
    }
}

