/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.monitoring;

import com.db4o.ObjectContainer;
import com.db4o.foundation.Environments;
import com.db4o.monitoring.Db4oMBean;
import com.db4o.monitoring.Db4oMBeanRegistry;
import com.db4o.monitoring.Db4oMBeans;
import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanRegistrationSupport
implements Db4oMBean {
    private ObjectContainer _db;
    private ObjectName _objectName;
    private Class<?> _type;

    public MBeanRegistrationSupport(ObjectContainer db, Class<?> type) {
        this._db = db;
        this._type = type;
        this.beanRegistry().add(this);
    }

    public MBeanRegistrationSupport(ObjectName objectName) throws JMException {
        this._objectName = objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister() {
        if (this.objectName() == null) {
            return;
        }
        try {
            this.platformMBeanServer().unregisterMBean(this.objectName());
        }
        catch (JMException e) {
            e.printStackTrace();
        }
        finally {
            this._db = null;
            this._objectName = null;
        }
    }

    @Override
    public void register() throws JMException {
        if (this.platformMBeanServer().isRegistered(this.objectName())) {
            return;
        }
        this.platformMBeanServer().registerMBean(this, this.objectName());
    }

    private MBeanServer platformMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    protected ObjectName objectName() {
        if (this._objectName != null) {
            return this._objectName;
        }
        if (this._db == null) {
            return null;
        }
        this._objectName = Db4oMBeans.mBeanNameFor(this._type, Db4oMBeans.mBeanIDForContainer(this._db));
        return this._objectName;
    }

    private Db4oMBeanRegistry beanRegistry() {
        return Environments.my(Db4oMBeanRegistry.class);
    }
}

