/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.slots;

public class Slot {
    private final int _address;
    private final int _length;
    public static final Slot ZERO = new Slot(0, 0);
    public static final int NEW = -1;
    public static final int UPDATE = -2;
    public static int MARSHALLED_LENGTH = 8;

    public Slot(int address, int length) {
        this._address = address;
        this._length = length;
    }

    public int address() {
        return this._address;
    }

    public int length() {
        return this._length;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Slot)) {
            return false;
        }
        Slot other = (Slot)obj;
        return this._address == other._address && this.length() == other.length();
    }

    public int hashCode() {
        return this._address ^ this.length();
    }

    public Slot subSlot(int offset) {
        return new Slot(this._address + offset, this.length() - offset);
    }

    public String toString() {
        return "[A:" + this._address + ",L:" + this.length() + "]";
    }

    public Slot truncate(int requiredLength) {
        return new Slot(this._address, requiredLength);
    }

    public int compareByAddress(Slot slot) {
        int res = slot._address - this._address;
        if (res != 0) {
            return res;
        }
        return slot.length() - this.length();
    }

    public int compareByLength(Slot slot) {
        int res = slot.length() - this.length();
        if (res != 0) {
            return res;
        }
        return slot._address - this._address;
    }

    public boolean isDirectlyPreceding(Slot other) {
        return this._address + this.length() == other._address;
    }

    public Slot append(Slot slot) {
        return new Slot(this.address(), this._length + slot.length());
    }

    public boolean isNull() {
        return this.address() == 0 || this.length() == 0;
    }

    public boolean isNew() {
        return this._address == -1;
    }

    public boolean isUpdate() {
        return this._address == -2;
    }

    public static boolean isNull(Slot slot) {
        return slot == null || slot.isNull();
    }
}

