/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.query.result;

import com.db4o.config.QueryEvaluationMode;
import com.db4o.foundation.IntComparator;
import com.db4o.foundation.IntIterator4;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ClassMetadataIterator;
import com.db4o.internal.Transaction;
import com.db4o.internal.query.processor.QQuery;
import com.db4o.internal.query.result.AbstractQueryResult;
import com.db4o.internal.query.result.IdListQueryResult;
import com.db4o.internal.query.result.LazyQueryResult;
import com.db4o.internal.query.result.SnapShotQueryResult;
import com.db4o.query.QueryComparator;

public class HybridQueryResult
extends AbstractQueryResult {
    private AbstractQueryResult _delegate;

    public HybridQueryResult(Transaction transaction, QueryEvaluationMode mode) {
        super(transaction);
        this._delegate = HybridQueryResult.forMode(transaction, mode);
    }

    private static AbstractQueryResult forMode(Transaction transaction, QueryEvaluationMode mode) {
        if (mode == QueryEvaluationMode.LAZY) {
            return new LazyQueryResult(transaction);
        }
        if (mode == QueryEvaluationMode.SNAPSHOT) {
            return new SnapShotQueryResult(transaction);
        }
        return new IdListQueryResult(transaction);
    }

    public Object get(int index) {
        this._delegate = this._delegate.supportElementAccess();
        return this._delegate.get(index);
    }

    public int getId(int index) {
        this._delegate = this._delegate.supportElementAccess();
        return this._delegate.getId(index);
    }

    public int indexOf(int id) {
        this._delegate = this._delegate.supportElementAccess();
        return this._delegate.indexOf(id);
    }

    public IntIterator4 iterateIDs() {
        return this._delegate.iterateIDs();
    }

    public Iterator4 iterator() {
        return this._delegate.iterator();
    }

    public void loadFromClassIndex(ClassMetadata clazz) {
        this._delegate.loadFromClassIndex(clazz);
    }

    public void loadFromClassIndexes(ClassMetadataIterator iterator) {
        this._delegate.loadFromClassIndexes(iterator);
    }

    public void loadFromIdReader(Iterator4 reader) {
        this._delegate.loadFromIdReader(reader);
    }

    public void loadFromQuery(QQuery query) {
        if (query.requiresSort()) {
            this._delegate = new IdListQueryResult(this.transaction());
        }
        this._delegate.loadFromQuery(query);
    }

    public int size() {
        this._delegate = this._delegate.supportSize();
        return this._delegate.size();
    }

    public void sort(QueryComparator cmp) {
        this._delegate = this._delegate.supportSort();
        this._delegate.sort(cmp);
    }

    public void sortIds(IntComparator cmp) {
        this._delegate = this._delegate.supportSort();
        this._delegate.sortIds(cmp);
    }
}

