/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.monitoring;

import com.db4o.ObjectContainer;
import com.db4o.events.Event4;
import com.db4o.events.EventListener4;
import com.db4o.events.EventRegistry;
import com.db4o.events.EventRegistryFactory;
import com.db4o.events.ObjectContainerEventArgs;
import com.db4o.foundation.Environments;
import com.db4o.monitoring.Db4oMBean;
import com.db4o.monitoring.Db4oMBeanRegistry;
import java.util.HashSet;
import java.util.Set;
import javax.management.JMException;

public class Db4oMBeanRegistryImpl
implements Db4oMBeanRegistry {
    private Set<Db4oMBean> _beans = new HashSet<Db4oMBean>();

    public Db4oMBeanRegistryImpl() {
        ObjectContainer db = Environments.my(ObjectContainer.class);
        EventRegistry eventRegistry = EventRegistryFactory.forObjectContainer(db);
        eventRegistry.opened().addListener(new EventListener4<ObjectContainerEventArgs>(){

            @Override
            public void onEvent(Event4<ObjectContainerEventArgs> event, ObjectContainerEventArgs args) {
                Db4oMBeanRegistryImpl.this.register();
            }
        });
        eventRegistry.closing().addListener(new EventListener4<ObjectContainerEventArgs>(){

            @Override
            public void onEvent(Event4<ObjectContainerEventArgs> event, ObjectContainerEventArgs args) {
                Db4oMBeanRegistryImpl.this.unregister();
            }
        });
    }

    public void add(Db4oMBean bean) {
        this._beans.add(bean);
    }

    public void register() {
        for (Db4oMBean bean : this._beans) {
            try {
                bean.register();
            }
            catch (JMException exc) {
                exc.printStackTrace();
            }
        }
    }

    public void unregister() {
        for (Db4oMBean bean : this._beans) {
            try {
                bean.unregister();
            }
            catch (JMException exc) {
                exc.printStackTrace();
            }
        }
    }
}

