/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.foundation.BitMap4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassAspect;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.Handlers4;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Transaction;
import com.db4o.internal.TranslatedAspect;
import com.db4o.internal.VirtualFieldMetadata;
import com.db4o.internal.encoding.LatinStringIO;
import com.db4o.internal.handlers.StandardReferenceTypeHandler;
import com.db4o.internal.handlers.StringHandler;
import com.db4o.internal.marshall.AbstractFieldMarshaller;
import com.db4o.internal.marshall.AspectType;
import com.db4o.internal.marshall.RawFieldSpec;
import com.db4o.internal.marshall.UnknownTypeHandlerAspect;
import com.db4o.typehandlers.TypeHandler4;

public class FieldMarshaller0
extends AbstractFieldMarshaller {
    public int marshalledLength(ObjectContainerBase stream, ClassAspect aspect) {
        int len = stream.stringIO().shortLength(aspect.getName());
        if (aspect instanceof FieldMetadata) {
            FieldMetadata field = (FieldMetadata)aspect;
            if (field.needsArrayAndPrimitiveInfo()) {
                ++len;
            }
            if (!(field instanceof VirtualFieldMetadata)) {
                len += 4;
            }
        }
        return len;
    }

    protected RawFieldSpec readSpec(AspectType aspectType, ObjectContainerBase stream, ByteArrayBuffer reader) {
        String name = StringHandler.readStringNoDebug(stream.transaction().context(), reader);
        if (!aspectType.isFieldMetadata()) {
            return new RawFieldSpec(aspectType, name);
        }
        if (name.indexOf("v4o") == 0 && stream._handlers.virtualFieldByName(name) != null) {
            return new RawFieldSpec(aspectType, name);
        }
        int fieldTypeID = reader.readInt();
        byte attribs = reader.readByte();
        return new RawFieldSpec(aspectType, name, fieldTypeID, attribs);
    }

    public final FieldMetadata read(ObjectContainerBase stream, ClassMetadata containingClass, ByteArrayBuffer reader) {
        RawFieldSpec spec = this.readSpec(stream, reader);
        return this.fromSpec(spec, stream, containingClass);
    }

    protected FieldMetadata fromSpec(RawFieldSpec spec, ObjectContainerBase stream, ClassMetadata containingClass) {
        if (spec == null) {
            return null;
        }
        String name = spec.name();
        if (spec.isVirtualField()) {
            return stream._handlers.virtualFieldByName(name);
        }
        if (spec.isTranslator()) {
            return new TranslatedAspect(containingClass, name);
        }
        if (spec.isField()) {
            return new FieldMetadata(containingClass, name, spec.fieldTypeID(), spec.isPrimitive(), spec.isArray(), spec.isNArray());
        }
        return new UnknownTypeHandlerAspect(containingClass, name);
    }

    public void write(Transaction trans, ClassMetadata clazz, ClassAspect aspect, ByteArrayBuffer writer) {
        writer.writeShortString(trans, aspect.getName());
        if (!(aspect instanceof FieldMetadata)) {
            return;
        }
        FieldMetadata field = (FieldMetadata)aspect;
        field.alive();
        if (field.isVirtual()) {
            return;
        }
        TypeHandler4 handler = field.getHandler();
        if (handler instanceof StandardReferenceTypeHandler && ((StandardReferenceTypeHandler)handler).classMetadata().getID() == 0) {
            trans.container().needsUpdate(clazz);
        }
        writer.writeInt(field.fieldTypeID());
        BitMap4 bitmap = new BitMap4(3);
        bitmap.set(0, field.isPrimitive());
        bitmap.set(1, Handlers4.handlesArray(handler));
        bitmap.set(2, Handlers4.handlesMultidimensionalArray(handler));
        writer.writeByte(bitmap.getByte(0));
    }

    public void defrag(ClassMetadata classMetadata, ClassAspect aspect, LatinStringIO sio, DefragmentContextImpl context) {
        context.incrementStringOffset(sio);
        if (!(aspect instanceof FieldMetadata)) {
            return;
        }
        if (((FieldMetadata)aspect).isVirtual()) {
            return;
        }
        context.copyID();
        context.incrementOffset(1);
    }
}

