/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.ids;

import com.db4o.config.IdSystemFactory;
import com.db4o.ext.Db4oFatalException;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.SystemData;
import com.db4o.internal.ids.BTreeIdSystem;
import com.db4o.internal.ids.IdSystem;
import com.db4o.internal.ids.InMemoryIdSystem;
import com.db4o.internal.ids.PointerBasedIdSystem;

public class StandardIdSystemFactory {
    public static final byte LEGACY = 0;
    public static final byte POINTER_BASED = 1;
    public static final byte STACKED_BTREE = 2;
    public static final byte DEFAULT = 2;
    public static final byte IN_MEMORY = 3;
    public static final byte CUSTOM = 4;
    public static final byte SINGLE_BTREE = 5;

    public static IdSystem newInstance(LocalObjectContainer localContainer) {
        SystemData systemData = localContainer.systemData();
        byte idSystemType = systemData.idSystemType();
        switch (idSystemType) {
            case 0: {
                return new PointerBasedIdSystem(localContainer);
            }
            case 1: {
                return new PointerBasedIdSystem(localContainer);
            }
            case 2: {
                InMemoryIdSystem inMemoryIdSystem = new InMemoryIdSystem(localContainer);
                BTreeIdSystem bTreeIdSystem = new BTreeIdSystem(localContainer, inMemoryIdSystem);
                systemData.freespaceIdSystem(bTreeIdSystem.freespaceIdSystem());
                return new BTreeIdSystem(localContainer, bTreeIdSystem);
            }
            case 5: {
                InMemoryIdSystem smallInMemoryIdSystem = new InMemoryIdSystem(localContainer);
                BTreeIdSystem smallBTreeIdSystem = new BTreeIdSystem(localContainer, smallInMemoryIdSystem);
                systemData.freespaceIdSystem(smallBTreeIdSystem.freespaceIdSystem());
                return smallBTreeIdSystem;
            }
            case 3: {
                return new InMemoryIdSystem(localContainer);
            }
            case 4: {
                IdSystemFactory customIdSystemFactory = localContainer.configImpl().customIdSystemFactory();
                if (customIdSystemFactory == null) {
                    throw new Db4oFatalException("Custom IdSystem configured but no factory was found. See IdSystemConfiguration#useCustomSystem()");
                }
                return customIdSystemFactory.newInstance(localContainer);
            }
        }
        return new PointerBasedIdSystem(localContainer);
    }
}

