/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.ids;

import com.db4o.DTrace;
import com.db4o.foundation.Closure4;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.LockedTree;
import com.db4o.internal.TreeInt;
import com.db4o.internal.freespace.FreespaceManager;
import com.db4o.internal.ids.FreespaceCommitter;
import com.db4o.internal.ids.IdSystem;
import com.db4o.internal.ids.TransactionalIdSystemImpl;
import com.db4o.internal.slots.Slot;
import com.db4o.internal.slots.SlotChange;
import com.db4o.internal.slots.SlotChangeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdSlotChanges {
    private final LockedTree _slotChanges = new LockedTree();
    private final TransactionalIdSystemImpl _idSystem;
    private final Closure4<FreespaceManager> _freespaceManager;
    private TreeInt _prefetchedIDs;

    public IdSlotChanges(TransactionalIdSystemImpl idSystem, Closure4<FreespaceManager> freespaceManager) {
        this._idSystem = idSystem;
        this._freespaceManager = freespaceManager;
    }

    public final void accumulateFreeSlots(final FreespaceCommitter freespaceCommitter, final boolean forFreespace, boolean traverseMutable) {
        Visitor4 visitor = new Visitor4(){

            public void visit(Object obj) {
                ((SlotChange)obj).accumulateFreeSlot(IdSlotChanges.this._idSystem, freespaceCommitter, forFreespace);
            }
        };
        if (traverseMutable) {
            this._slotChanges.traverseMutable(visitor);
        } else {
            this._slotChanges.traverseLocked(visitor);
        }
    }

    public void clear() {
        this._slotChanges.clear();
    }

    public void rollback() {
        this._slotChanges.traverseLocked(new Visitor4(){

            public void visit(Object slotChange) {
                ((SlotChange)slotChange).rollback(IdSlotChanges.this.freespaceManager());
            }
        });
    }

    public boolean isDeleted(int id) {
        SlotChange slot = this.findSlotChange(id);
        if (slot == null) {
            return false;
        }
        return slot.isDeleted();
    }

    public SlotChange produceSlotChange(int id, SlotChangeFactory slotChangeFactory) {
        if (DTrace.enabled) {
            DTrace.PRODUCE_SLOT_CHANGE.log(id);
        }
        SlotChange slot = slotChangeFactory.newInstance(id);
        this._slotChanges.add(slot);
        return (SlotChange)slot.addedOrExisting();
    }

    public final SlotChange findSlotChange(int id) {
        return (SlotChange)this._slotChanges.find(id);
    }

    public void traverseSlotChanges(Visitor4<SlotChange> visitor) {
        this._slotChanges.traverseLocked(visitor);
    }

    public boolean isDirty() {
        return !this._slotChanges.isEmpty();
    }

    public void readSlotChanges(ByteArrayBuffer buffer) {
        this._slotChanges.read(buffer, new SlotChange(0));
    }

    public void addPrefetchedID(int id) {
        this._prefetchedIDs = Tree.add(this._prefetchedIDs, new TreeInt(id));
    }

    public void prefetchedIDConsumed(int id) {
        this._prefetchedIDs = this._prefetchedIDs.removeLike(new TreeInt(id));
    }

    final void freePrefetchedIDs(IdSystem idSystem) {
        if (this._prefetchedIDs == null) {
            return;
        }
        idSystem.returnUnusedIds(this._prefetchedIDs);
        this._prefetchedIDs = null;
    }

    public void notifySlotCreated(int id, Slot slot, SlotChangeFactory slotChangeFactory) {
        this.produceSlotChange(id, slotChangeFactory).notifySlotCreated(slot);
    }

    void notifySlotUpdated(int id, Slot slot, SlotChangeFactory slotChangeFactory) {
        this.produceSlotChange(id, slotChangeFactory).notifySlotUpdated(this.freespaceManager(), slot);
    }

    public void notifySlotDeleted(int id, SlotChangeFactory slotChangeFactory) {
        this.produceSlotChange(id, slotChangeFactory).notifyDeleted(this.freespaceManager());
    }

    private FreespaceManager freespaceManager() {
        return this._freespaceManager.run();
    }
}

