/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.events;

import com.db4o.events.Event4;
import com.db4o.events.EventArgs;
import com.db4o.events.EventListener4;
import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Event4Impl<T extends EventArgs>
implements Event4<T> {
    private Collection4 _listeners;

    public static <T extends EventArgs> Event4Impl<T> newInstance() {
        return new Event4Impl<T>();
    }

    protected Event4Impl() {
    }

    @Override
    public final void addListener(EventListener4<T> listener) {
        this.validateListener(listener);
        Collection4<EventListener4<T>> listeners = new Collection4<EventListener4<T>>();
        listeners.add(listener);
        if (null != this._listeners) {
            listeners.addAll(this._listeners);
        }
        this._listeners = listeners;
        this.onListenerAdded();
    }

    private Collection4 copyListeners() {
        return null != this._listeners ? new Collection4(this._listeners) : new Collection4();
    }

    protected void onListenerAdded() {
    }

    @Override
    public final void removeListener(EventListener4<T> listener) {
        this.validateListener(listener);
        if (null == this._listeners) {
            return;
        }
        Collection4 listeners = this.copyListeners();
        listeners.remove(listener);
        this._listeners = listeners;
    }

    public final void trigger(T args) {
        if (null == this._listeners) {
            return;
        }
        Iterator4 iterator = this._listeners.iterator();
        while (iterator.moveNext()) {
            EventListener4 listener = (EventListener4)iterator.current();
            listener.onEvent(this, args);
        }
    }

    private void validateListener(EventListener4<T> listener) {
        if (null == listener) {
            throw new ArgumentNullException();
        }
    }

    public boolean hasListeners() {
        return this._listeners != null;
    }
}

