/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cluster;

import com.db4o.ObjectSet;
import com.db4o.cluster.Cluster;
import com.db4o.ext.ExtObjectContainer;
import com.db4o.foundation.CompositeIterator4;
import com.db4o.foundation.IntComparator;
import com.db4o.foundation.IntIterator4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.NotSupportedException;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ClassMetadataIterator;
import com.db4o.internal.query.ObjectSetFacade;
import com.db4o.internal.query.processor.QQuery;
import com.db4o.internal.query.result.QueryResult;
import com.db4o.query.Query;
import com.db4o.query.QueryComparator;

public class ClusterQueryResult
implements QueryResult {
    private final Cluster _cluster;
    private final ObjectSet[] _objectSets;
    private final int[] _sizes;
    private final int _size;

    public ClusterQueryResult(Cluster cluster, Query[] queries) {
        this._cluster = cluster;
        this._objectSets = new ObjectSet[queries.length];
        this._sizes = new int[queries.length];
        int size = 0;
        for (int i = 0; i < queries.length; ++i) {
            this._objectSets[i] = queries[i].execute();
            this._sizes[i] = this._objectSets[i].size();
            size += this._sizes[i];
        }
        this._size = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntIterator4 iterateIDs() {
        Cluster cluster = this._cluster;
        synchronized (cluster) {
            Iterator4[] iterators = new Iterator4[this._objectSets.length];
            for (int i = 0; i < this._objectSets.length; ++i) {
                iterators[i] = ((ObjectSetFacade)this._objectSets[i])._delegate.iterateIDs();
            }
            return new ClusterQueryResultIntIterator(iterators);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator4 iterator() {
        Cluster cluster = this._cluster;
        synchronized (cluster) {
            Iterator4[] iterators = new Iterator4[this._objectSets.length];
            for (int i = 0; i < this._objectSets.length; ++i) {
                iterators[i] = ((ObjectSetFacade)this._objectSets[i])._delegate.iterator();
            }
            return new CompositeIterator4(iterators);
        }
    }

    public int size() {
        return this._size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int index) {
        Cluster cluster = this._cluster;
        synchronized (cluster) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            int i = 0;
            while (index >= this._sizes[i]) {
                index -= this._sizes[i];
                ++i;
            }
            return ((ObjectSetFacade)this._objectSets[i]).get(index);
        }
    }

    public Object lock() {
        return this._cluster;
    }

    public ExtObjectContainer objectContainer() {
        throw new NotSupportedException();
    }

    public int indexOf(int id) {
        throw new NotSupportedException();
    }

    public void sort(QueryComparator cmp) {
        throw new NotSupportedException();
    }

    public void sortIds(IntComparator cmp) {
        throw new NotSupportedException();
    }

    public void loadFromClassIndex(ClassMetadata c) {
        throw new NotSupportedException();
    }

    public void loadFromQuery(QQuery q) {
        throw new NotSupportedException();
    }

    public void loadFromClassIndexes(ClassMetadataIterator i) {
        throw new NotSupportedException();
    }

    public void loadFromIdReader(ByteArrayBuffer r) {
        throw new NotSupportedException();
    }

    private static final class ClusterQueryResultIntIterator
    implements IntIterator4 {
        private final CompositeIterator4 _delegate;

        public ClusterQueryResultIntIterator(Iterator4[] iterators) {
            this._delegate = new CompositeIterator4(iterators);
        }

        public boolean moveNext() {
            return this._delegate.moveNext();
        }

        public Object current() {
            return this._delegate.current();
        }

        public void reset() {
            this._delegate.reset();
        }

        public int currentInt() {
            return ((IntIterator4)this._delegate.currentIterator()).currentInt();
        }
    }
}

