/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.caching;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.CircularBuffer4;
import com.db4o.foundation.Function4;
import com.db4o.foundation.Iterable4;
import com.db4o.foundation.Iterators;
import com.db4o.foundation.Procedure4;
import com.db4o.internal.caching.Cache4;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LRU2QCache<K, V>
implements Cache4<K, V> {
    private final CircularBuffer4<K> _am;
    private final CircularBuffer4<K> _a1;
    private final Map<K, V> _slots;
    private final int _maxSize;
    private final int _a1_threshold;

    LRU2QCache(int maxSize) {
        this._maxSize = maxSize;
        this._a1_threshold = this._maxSize / 4;
        this._am = new CircularBuffer4(this._maxSize);
        this._a1 = new CircularBuffer4(this._maxSize);
        this._slots = new HashMap(maxSize);
    }

    @Override
    public V produce(K key, Function4<K, V> producer, Procedure4<V> finalizer) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        if (this._am.remove(key)) {
            this._am.addFirst(key);
            return this._slots.get(key);
        }
        if (this._a1.remove(key)) {
            this._am.addFirst(key);
            return this._slots.get(key);
        }
        if (this._slots.size() >= this._maxSize) {
            this.discardPage(finalizer);
        }
        V value = producer.apply(key);
        this._slots.put(key, value);
        this._a1.addFirst(key);
        return value;
    }

    private void discardPage(Procedure4<V> finalizer) {
        if (this._a1.size() >= this._a1_threshold) {
            this.discardPageFrom(this._a1, finalizer);
        } else {
            this.discardPageFrom(this._am, finalizer);
        }
    }

    private void discardPageFrom(CircularBuffer4<K> list, Procedure4<V> finalizer) {
        this.discard(list.removeLast(), finalizer);
    }

    private void discard(K key, Procedure4<V> finalizer) {
        if (null != finalizer) {
            finalizer.apply(this._slots.get(key));
        }
        this._slots.remove(key);
    }

    public String toString() {
        return "LRU2QCache(am=" + this.toString(this._am) + ", a1=" + this.toString(this._a1) + ")";
    }

    private String toString(Iterable4<K> buffer) {
        return Iterators.toString(buffer);
    }

    @Override
    public Iterator<V> iterator() {
        return this._slots.values().iterator();
    }
}

