/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.activation;

import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Class;
import com.db4o.internal.activation.ActivationDepth;
import com.db4o.internal.activation.ActivationDepthImpl;
import com.db4o.internal.activation.ActivationMode;

public class LegacyActivationDepth
extends ActivationDepthImpl {
    private final int _depth;

    public LegacyActivationDepth(int depth) {
        this(depth, ActivationMode.ACTIVATE);
    }

    public LegacyActivationDepth(int depth, ActivationMode mode) {
        super(mode);
        this._depth = depth;
    }

    public ActivationDepth descend(ClassMetadata metadata) {
        if (null == metadata) {
            return new LegacyActivationDepth(this._depth - 1, this._mode);
        }
        return new LegacyActivationDepth(this.descendDepth(metadata), this._mode);
    }

    private int descendDepth(ClassMetadata metadata) {
        int depth = this.configuredActivationDepth(metadata) - 1;
        if (metadata.isStruct()) {
            return Math.max(1, depth);
        }
        return depth;
    }

    private int configuredActivationDepth(ClassMetadata metadata) {
        Config4Class config = metadata.configOrAncestorConfig();
        if (config != null && this._mode.isActivate()) {
            return config.adjustActivationDepth(this._depth);
        }
        return this._depth;
    }

    public boolean requiresActivation() {
        return this._depth > 0;
    }
}

