/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.activation;

import com.db4o.internal.ClassMetadata;
import com.db4o.internal.activation.DepthUtil;
import com.db4o.internal.activation.UpdateDepth;

public abstract class FixedUpdateDepth
implements UpdateDepth {
    private int _depth;
    private boolean _tpMode = false;

    public FixedUpdateDepth(int depth) {
        this._depth = depth;
    }

    public void tpMode(boolean tpMode) {
        this._tpMode = tpMode;
    }

    public boolean tpMode() {
        return this._tpMode;
    }

    public boolean sufficientDepth() {
        return this._depth > 0;
    }

    public boolean negative() {
        return this._depth < 0;
    }

    public String toString() {
        return this.getClass().getName() + ": " + this._depth;
    }

    public UpdateDepth adjust(ClassMetadata clazz) {
        if (clazz.cascadesOnDeleteOrUpdate()) {
            return this.adjustDepthToBorders().descend();
        }
        return this.descend();
    }

    public boolean isBroaderThan(FixedUpdateDepth other) {
        return this._depth > other._depth;
    }

    public FixedUpdateDepth adjustDepthToBorders() {
        return this.forDepth(DepthUtil.adjustDepthToBorders(this._depth));
    }

    public UpdateDepth adjustUpdateDepthForCascade(boolean isCollection) {
        int minimumUpdateDepth;
        int n = minimumUpdateDepth = isCollection ? 2 : 1;
        if (this._depth < minimumUpdateDepth) {
            return this.forDepth(minimumUpdateDepth);
        }
        return this;
    }

    public UpdateDepth descend() {
        return this.forDepth(this._depth - 1);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this._depth == ((FixedUpdateDepth)other)._depth;
    }

    public int hashCode() {
        return this._depth;
    }

    protected abstract FixedUpdateDepth forDepth(int var1);
}

