/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.SerializedGraph;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TransportObjectContainer;
import com.db4o.internal.activation.FullActivationDepth;
import com.db4o.io.ConstantGrowthStrategy;
import com.db4o.io.GrowthStrategy;
import com.db4o.io.MemoryBin;

public class Serializer {
    public static StatefulBuffer marshall(Transaction ta, Object obj) {
        SerializedGraph serialized = Serializer.marshall(ta.container(), obj);
        StatefulBuffer buffer = new StatefulBuffer(ta, serialized.length());
        buffer.append(serialized._bytes);
        buffer.useSlot(serialized._id, 0, serialized.length());
        return buffer;
    }

    public static SerializedGraph marshall(ObjectContainerBase serviceProvider, Object obj) {
        MemoryBin memoryBin = new MemoryBin(223, (GrowthStrategy)Serializer.growthStrategy());
        TransportObjectContainer carrier = Serializer.newTransportObjectContainer(serviceProvider, memoryBin);
        carrier.produceClassMetadata(carrier.reflector().forObject(obj));
        carrier.store(obj);
        int id = (int)carrier.getID(obj);
        carrier.close();
        return new SerializedGraph(id, memoryBin.data());
    }

    private static ConstantGrowthStrategy growthStrategy() {
        return new ConstantGrowthStrategy(300);
    }

    private static TransportObjectContainer newTransportObjectContainer(ObjectContainerBase serviceProvider, MemoryBin memoryBin) {
        TransportObjectContainer container = new TransportObjectContainer(serviceProvider, memoryBin);
        container.deferredOpen();
        return container;
    }

    public static Object unmarshall(ObjectContainerBase serviceProvider, StatefulBuffer buffer) {
        return Serializer.unmarshall(serviceProvider, buffer._buffer, buffer.getID());
    }

    public static Object unmarshall(ObjectContainerBase serviceProvider, SerializedGraph serialized) {
        return Serializer.unmarshall(serviceProvider, serialized._bytes, serialized._id);
    }

    public static Object unmarshall(ObjectContainerBase serviceProvider, byte[] bytes, int id) {
        if (id <= 0) {
            return null;
        }
        MemoryBin memoryBin = new MemoryBin(bytes, (GrowthStrategy)Serializer.growthStrategy());
        TransportObjectContainer carrier = Serializer.newTransportObjectContainer(serviceProvider, memoryBin);
        Object obj = carrier.getByID(id);
        carrier.activate(carrier.transaction(), obj, new FullActivationDepth());
        carrier.close();
        return obj;
    }
}

