/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.DTrace;
import com.db4o.foundation.Collection4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.Identifiable;
import com.db4o.internal.LinkLengthAware;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.Persistent;
import com.db4o.internal.Transaction;
import com.db4o.internal.ids.TransactionalIdSystem;
import com.db4o.internal.slots.Slot;
import com.db4o.internal.slots.SlotChangeFactory;

public abstract class PersistentBase
extends Identifiable
implements Persistent,
LinkLengthAware {
    void cacheDirty(Collection4 col) {
        if (!this.bitIsTrue(3)) {
            this.bitTrue(3);
            col.add(this);
        }
    }

    public void free(LocalTransaction trans) {
        this.idSystem(trans.systemTransaction()).notifySlotDeleted(this.getID(), this.slotChangeFactory());
    }

    public final int linkLength() {
        return 4;
    }

    final void notCachedDirty() {
        this.bitFalse(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Transaction trans) {
        if (!this.beginProcessing()) {
            return;
        }
        try {
            this.read(trans, this.produceReadBuffer(trans));
        }
        finally {
            this.endProcessing();
        }
    }

    protected void read(Transaction trans, ByteArrayBuffer reader) {
        this.readThis(trans, reader);
        this.setStateOnRead(reader);
    }

    protected final ByteArrayBuffer produceReadBuffer(Transaction trans) {
        return this.readBufferById(trans);
    }

    protected ByteArrayBuffer readBufferById(Transaction trans) {
        return trans.container().readBufferById(trans, this.getID());
    }

    void setStateOnRead(ByteArrayBuffer reader) {
        if (this.bitIsTrue(3)) {
            this.setStateDirty();
        } else {
            this.setStateClean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Transaction trans) {
        if (!this.writeObjectBegin()) {
            return;
        }
        try {
            LocalObjectContainer container = (LocalObjectContainer)trans.container();
            if (DTrace.enabled) {
                DTrace.PERSISTENT_OWN_LENGTH.log(this.getID());
            }
            int length = this.ownLength();
            length = container.blockConverter().blockAlignedBytes(length);
            Slot slot = container.allocateSlot(length);
            if (this.isNew()) {
                this.setID(this.idSystem(trans).newId(this.slotChangeFactory()));
                this.idSystem(trans).notifySlotCreated(this._id, slot, this.slotChangeFactory());
            } else {
                this.idSystem(trans).notifySlotUpdated(this._id, slot, this.slotChangeFactory());
            }
            if (DTrace.enabled) {
                DTrace.PERSISTENT_BASE_NEW_SLOT.logLength((long)this.getID(), slot);
            }
            ByteArrayBuffer writer = this.produceWriteBuffer(trans, length);
            this.writeToFile(trans, writer, slot);
        }
        finally {
            this.endProcessing();
        }
    }

    public TransactionalIdSystem idSystem(Transaction trans) {
        return trans.idSystem();
    }

    protected ByteArrayBuffer produceWriteBuffer(Transaction trans, int length) {
        return this.newWriteBuffer(length);
    }

    protected ByteArrayBuffer newWriteBuffer(int length) {
        return new ByteArrayBuffer(length);
    }

    private final void writeToFile(Transaction trans, ByteArrayBuffer writer, Slot slot) {
        if (DTrace.enabled) {
            DTrace.PERSISTENTBASE_WRITE.log(this.getID());
        }
        LocalObjectContainer container = (LocalObjectContainer)trans.container();
        this.writeThis(trans, writer);
        container.writeEncrypt(writer, slot.address(), 0);
        if (this.isActive()) {
            this.setStateClean();
        }
    }

    public boolean writeObjectBegin() {
        if (this.isDirty()) {
            return this.beginProcessing();
        }
        return false;
    }

    public void writeOwnID(Transaction trans, ByteArrayBuffer writer) {
        this.write(trans);
        writer.writeInt(this.getID());
    }

    public SlotChangeFactory slotChangeFactory() {
        return SlotChangeFactory.SYSTEM_OBJECTS;
    }
}

