/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.events.CommitEventArgs;
import com.db4o.events.Event4;
import com.db4o.events.EventListener4;
import com.db4o.events.EventRegistryFactory;
import com.db4o.ext.ObjectInfo;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.PreparedComparison;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.Indexable4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.FieldIndexKey;
import com.db4o.internal.handlers.IntHandler;
import com.db4o.internal.handlers.LongHandler;
import com.db4o.marshall.Context;

public class CommitTimestampSupport {
    private BTree _idToTimestamp;
    private BTree _timestampToId;
    private final LocalObjectContainer _container;

    public CommitTimestampSupport(LocalObjectContainer container) {
        this._container = container;
    }

    public void ensureInitialized() {
        if (this._idToTimestamp != null) {
            return;
        }
        if (!this._container.config().generateCommitTimestamps().definiteYes()) {
            return;
        }
        this.initialize();
    }

    public BTree idToTimestamp() {
        if (this._idToTimestamp != null) {
            return this._idToTimestamp;
        }
        this.ensureInitialized();
        return this._idToTimestamp;
    }

    public BTree timestampToId() {
        if (this._timestampToId != null) {
            return this._timestampToId;
        }
        this.ensureInitialized();
        return this._timestampToId;
    }

    private void initialize() {
        int idToTimestampIndexId = this._container.systemData().idToTimestampIndexId();
        int timestampToIdIndexId = this._container.systemData().timestampToIdIndexId();
        if (this._container.config().isReadOnly() && idToTimestampIndexId == 0) {
            return;
        }
        this._idToTimestamp = new BTree(this._container.systemTransaction(), idToTimestampIndexId, (Indexable4)new TimestampEntryById());
        this._timestampToId = new BTree(this._container.systemTransaction(), timestampToIdIndexId, (Indexable4)new IdEntryByTimestamp());
        if (idToTimestampIndexId != this._idToTimestamp.getID()) {
            this.storeBtreesIds();
        }
        EventRegistryFactory.forObjectContainer(this._container).committing().addListener(new EventListener4<CommitEventArgs>(){

            @Override
            public void onEvent(Event4<CommitEventArgs> e, CommitEventArgs args) {
                LocalTransaction trans = (LocalTransaction)args.transaction();
                long transactionTimestamp = trans.timestamp();
                long commitTimestamp = transactionTimestamp > 0L ? transactionTimestamp : CommitTimestampSupport.this._container.generateTimeStampId();
                Transaction sysTrans = trans.systemTransaction();
                this.addTimestamp(sysTrans, args.added().iterator(), commitTimestamp);
                this.addTimestamp(sysTrans, args.updated().iterator(), commitTimestamp);
                this.addTimestamp(sysTrans, args.deleted().iterator(), 0L);
            }

            private void addTimestamp(Transaction trans, Iterator4 it, long commitTimestamp) {
                while (it.moveNext()) {
                    ObjectInfo objInfo = (ObjectInfo)it.current();
                    TimestampEntry te = new TimestampEntry((int)objInfo.getInternalID(), commitTimestamp);
                    TimestampEntry oldEntry = (TimestampEntry)CommitTimestampSupport.this._idToTimestamp.remove(trans, te);
                    if (oldEntry != null) {
                        CommitTimestampSupport.this._timestampToId.remove(trans, oldEntry);
                    }
                    if (commitTimestamp == 0L) continue;
                    CommitTimestampSupport.this._idToTimestamp.add(trans, te);
                    CommitTimestampSupport.this._timestampToId.add(trans, te);
                }
            }
        });
    }

    private void storeBtreesIds() {
        this._container.systemData().idToTimestampIndexId(this._idToTimestamp.getID());
        this._container.systemData().timestampToIdIndexId(this._timestampToId.getID());
        this._container.getFileHeader().writeVariablePart(this._container);
    }

    public long versionForId(int id) {
        if (this.idToTimestamp() == null || id == 0) {
            return 0L;
        }
        TimestampEntry te = (TimestampEntry)this.idToTimestamp().search(this._container.systemTransaction(), new TimestampEntry(id, 0L));
        if (te == null) {
            return 0L;
        }
        return te.getCommitTimestamp();
    }

    public void put(Transaction trans, int objectId, long version) {
        TimestampEntry te = new TimestampEntry(objectId, version);
        this.idToTimestamp().add(trans, te);
        this.timestampToId().add(trans, te);
    }

    private static final class IdEntryByTimestamp
    extends TimestampEntryById {
        private IdEntryByTimestamp() {
        }

        public PreparedComparison prepareComparison(Context context, final TimestampEntry first) {
            return new PreparedComparison<TimestampEntry>(){

                @Override
                public int compareTo(TimestampEntry second) {
                    int result = LongHandler.compare(first.commitTimestamp, second.commitTimestamp);
                    if (result != 0) {
                        return result;
                    }
                    return IntHandler.compare(first.objectId, second.objectId);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TimestampEntryById
    implements Indexable4<TimestampEntry> {
        private TimestampEntryById() {
        }

        @Override
        public PreparedComparison prepareComparison(Context context, final TimestampEntry first) {
            return new PreparedComparison<TimestampEntry>(){

                @Override
                public int compareTo(TimestampEntry second) {
                    return IntHandler.compare(first.objectId, second.objectId);
                }
            };
        }

        @Override
        public int linkLength() {
            return 12;
        }

        @Override
        public TimestampEntry readIndexEntry(Context context, ByteArrayBuffer reader) {
            return new TimestampEntry(reader.readInt(), reader.readLong());
        }

        @Override
        public void writeIndexEntry(Context context, ByteArrayBuffer writer, TimestampEntry obj) {
            writer.writeInt(obj.parentID());
            writer.writeLong(obj.getCommitTimestamp());
        }

        @Override
        public void defragIndexEntry(DefragmentContextImpl context) {
            throw new UnsupportedOperationException();
        }
    }

    public static class TimestampEntry
    implements FieldIndexKey {
        public final int objectId;
        public final long commitTimestamp;

        public String toString() {
            return "TimestampEntry [objectId=" + this.objectId + ", commitTimestamp=" + this.commitTimestamp + "]";
        }

        public TimestampEntry(int objectId, long commitTimestamp) {
            this.objectId = objectId;
            this.commitTimestamp = commitTimestamp;
        }

        public int parentID() {
            return this.objectId;
        }

        public long getCommitTimestamp() {
            return this.commitTimestamp;
        }

        public Object value() {
            return this.commitTimestamp;
        }
    }
}

