/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.util;

import com.db4o.foundation.io.File4;
import com.db4o.instrumentation.util.ZipFileWriter;
import java.io.File;
import java.io.IOException;

public class ZipFileCreation {
    private final ZipFileWriter _zipFile;
    private final File _baseDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipFileCreation(File sourceDir, File outputFile) throws IOException {
        this._baseDir = sourceDir.getCanonicalFile();
        this._zipFile = new ZipFileWriter(outputFile);
        try {
            this.writeEntries(this._baseDir.listFiles());
        }
        finally {
            this._zipFile.close();
        }
    }

    private void writeEntries(File[] files) throws IOException {
        for (int i = 0; i < files.length; ++i) {
            this.writeEntry(files[i]);
        }
    }

    private void writeEntry(File file) throws IOException {
        if (file.isDirectory()) {
            this.writeEntries(file.listFiles());
            return;
        }
        this.writeFileEntry(file);
    }

    private void writeFileEntry(File file) throws IOException {
        this._zipFile.writeEntry(this.relativePath(file).replace('\\', '/'), this.readAllBytes(file));
    }

    private byte[] readAllBytes(File file) throws IOException {
        return File4.readAllBytes(file.getAbsolutePath());
    }

    private String relativePath(File file) throws IOException {
        String basePath = this._baseDir.getAbsolutePath();
        String filePath = file.getCanonicalPath();
        this.assertPathPrefix(basePath, filePath);
        return filePath.substring(basePath.length() + 1);
    }

    private void assertPathPrefix(String expectedPrefix, String actualPath) {
        if (!actualPath.startsWith(expectedPrefix)) {
            throw new IllegalStateException();
        }
    }
}

