/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.util;

import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.Type;
import com.db4o.instrumentation.core.BloatLoaderContext;
import com.db4o.instrumentation.util.LoadStoreInstructions;
import java.io.File;

public class BloatUtil {
    public static String normalizeClassName(Type type) {
        return BloatUtil.normalizeClassName(type.className());
    }

    public static String normalizeClassName(String className) {
        return className.replace('/', '.');
    }

    public static Class classForEditor(ClassEditor ce, ClassLoader loader) throws ClassNotFoundException {
        String clazzName = BloatUtil.normalizeClassName(ce.name());
        return loader.loadClass(clazzName);
    }

    public static boolean isPlatformClassName(String name) {
        return name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("sun.");
    }

    public static String classNameForPath(String classPath) {
        String className = classPath.substring(0, classPath.length() - ".class".length());
        return className.replace(File.separatorChar, '.');
    }

    public static String classPathForName(String className) {
        String classPath = className.replace('.', '/');
        return classPath + ".class";
    }

    private BloatUtil() {
    }

    public static LoadStoreInstructions loadStoreInstructionsFor(Type type) {
        if (type.isPrimitive()) {
            switch (type.typeCode()) {
                case 7: {
                    return new LoadStoreInstructions(24, 57);
                }
                case 6: {
                    return new LoadStoreInstructions(23, 56);
                }
                case 11: {
                    return new LoadStoreInstructions(22, 55);
                }
            }
            return new LoadStoreInstructions(21, 54);
        }
        return new LoadStoreInstructions(25, 58);
    }

    public static boolean implementsInHierarchy(ClassEditor ce, Class markerInterface, BloatLoaderContext context) throws ClassNotFoundException {
        while (ce != null) {
            if (BloatUtil.implementsDirectly(ce, markerInterface)) {
                return true;
            }
            ce = context.classEditor(ce.superclass());
        }
        return false;
    }

    public static boolean implementsDirectly(ClassEditor ce, Class markerInterface) {
        if (markerInterface.getName().equals(BloatUtil.normalizeClassName(ce.type()))) {
            return true;
        }
        Type[] interfaces = ce.interfaces();
        for (int idx = 0; idx < interfaces.length; ++idx) {
            Type type = interfaces[idx];
            if (!BloatUtil.normalizeClassName(type).equals(markerInterface.getName())) continue;
            return true;
        }
        return false;
    }
}

