/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation.io;

import com.db4o.foundation.io.File4;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;

public class Path4 {
    private static final Random _random = new Random();

    public static String getDirectoryName(String targetPath) {
        return new File(targetPath).getParent();
    }

    public static String combine(String parent, String child) {
        return parent.endsWith(File.separator) ? parent + child : parent + File.separator + child;
    }

    public static String getTempPath() {
        String path = System.getProperty("java.io.tmpdir");
        if (path == null || path.length() <= 1) {
            path = "/temp";
        }
        File4.mkdirs(path);
        return path;
    }

    public static String getTempFileName() {
        String fname;
        String tempPath = Path4.getTempPath();
        while (File4.exists(fname = Path4.combine(tempPath, "db4o-test-" + Path4.nextRandom() + ".tmp"))) {
        }
        try {
            new FileWriter(fname).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        return fname;
    }

    private static String nextRandom() {
        return Integer.toHexString(_random.nextInt());
    }
}

