/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.diagnostic;

import com.db4o.diagnostic.DiagnosticBase;

public class NativeQueryOptimizerNotLoaded
extends DiagnosticBase {
    private int _reason;
    private final Exception _details;
    public static final int NQ_NOT_PRESENT = 1;
    public static final int NQ_CONSTRUCTION_FAILED = 2;

    public NativeQueryOptimizerNotLoaded(int reason, Exception details) {
        this._reason = reason;
        this._details = details;
    }

    public String problem() {
        return "Native Query Optimizer could not be loaded";
    }

    public Object reason() {
        switch (this._reason) {
            case 1: {
                return this.AppendDetails("Native query not present.");
            }
            case 2: {
                return this.AppendDetails("Native query couldn't be instantiated.");
            }
        }
        return this.AppendDetails("Reason not specified.");
    }

    public String solution() {
        return "If you to have the native queries optimized, please check that the native query jar is present in the class-path.";
    }

    private Object AppendDetails(String reason) {
        if (this._details == null) {
            return reason;
        }
        return reason + "\n" + this._details.toString();
    }
}

