/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.cs.monitoring;

import com.db4o.ObjectContainer;
import com.db4o.cs.foundation.ServerSocket4;
import com.db4o.cs.foundation.ServerSocket4Decorator;
import com.db4o.cs.foundation.Socket4;
import com.db4o.cs.monitoring.Db4oClientServerMBeans;
import com.db4o.cs.monitoring.MonitoredServerSideClientSocket4;
import com.db4o.cs.monitoring.Networking;
import com.db4o.events.Event4;
import com.db4o.events.EventListener4;
import com.db4o.events.EventRegistry;
import com.db4o.events.EventRegistryFactory;
import com.db4o.events.ObjectContainerEventArgs;
import com.db4o.foundation.Environments;
import java.io.IOException;
import javax.management.JMException;

class MonitoredServerSocket4
extends ServerSocket4Decorator {
    private Networking _bean;

    public MonitoredServerSocket4(ServerSocket4 serverSocket) {
        super(serverSocket);
    }

    public Socket4 accept() throws IOException {
        return new MonitoredServerSideClientSocket4(this._serverSocket.accept(), this.bean());
    }

    Networking bean() {
        if (this._bean == null) {
            this._bean = Db4oClientServerMBeans.newServerNetworkingStatsMBean(Environments.my(ObjectContainer.class));
            try {
                this._bean.register();
            }
            catch (JMException exc) {
                exc.printStackTrace();
            }
            this.unregisterBeanOnServerClose();
        }
        return this._bean;
    }

    private void unregisterBeanOnServerClose() {
        EventRegistry events = EventRegistryFactory.forObjectContainer(Environments.my(ObjectContainer.class));
        events.closing().addListener(new EventListener4<ObjectContainerEventArgs>(){

            @Override
            public void onEvent(Event4<ObjectContainerEventArgs> e, ObjectContainerEventArgs args) {
                MonitoredServerSocket4.this._bean.unregister();
                MonitoredServerSocket4.this._bean = null;
            }
        });
    }
}

