/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.cs.internal.messages;

import com.db4o.cs.internal.Socket4Adapter;
import com.db4o.cs.internal.messages.MessageDispatcher;
import com.db4o.cs.internal.messages.Msg;
import com.db4o.foundation.IntIterators;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.Const4;
import com.db4o.internal.SerializedGraph;
import com.db4o.internal.Serializer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;

public class MsgD
extends Msg {
    StatefulBuffer _payLoad;

    MsgD() {
    }

    MsgD(String aName) {
        super(aName);
    }

    public ByteArrayBuffer getByteLoad() {
        return this._payLoad;
    }

    public final StatefulBuffer payLoad() {
        return this._payLoad;
    }

    public void payLoad(StatefulBuffer writer) {
        this._payLoad = writer;
    }

    public final MsgD getWriterForByte(Transaction trans, byte b) {
        MsgD msg = this.getWriterForLength(trans, 1);
        msg._payLoad.writeByte(b);
        return msg;
    }

    public final MsgD getWriterForBuffer(Transaction trans, ByteArrayBuffer buffer) {
        MsgD writer = this.getWriterForLength(trans, buffer.length());
        writer.writeBytes(buffer._buffer);
        return writer;
    }

    public final MsgD getWriterForLength(Transaction trans, int length) {
        MsgD message = (MsgD)this.publicClone();
        message.setTransaction(trans);
        message._payLoad = new StatefulBuffer(trans, length + 9);
        message.writeInt(this._msgID);
        message.writeInt(length);
        if (trans.parentTransaction() == null) {
            message._payLoad.writeByte((byte)115);
        } else {
            message._payLoad.writeByte((byte)117);
        }
        return message;
    }

    public final MsgD getWriter(Transaction trans) {
        return this.getWriterForLength(trans, 0);
    }

    public final MsgD getWriterForInts(Transaction trans, int ... ints) {
        MsgD message = this.getWriterForLength(trans, 4 * ints.length);
        for (int i = 0; i < ints.length; ++i) {
            message.writeInt(ints[i]);
        }
        return message;
    }

    public final MsgD getWriterForIntArray(Transaction a_trans, int[] ints, int length) {
        return this.getWriterForIntSequence(a_trans, length, IntIterators.forInts(ints, length));
    }

    public MsgD getWriterForIntSequence(Transaction trans, int length, Iterator4 iterator) {
        MsgD message = this.getWriterForLength(trans, 4 * (length + 1));
        message.writeInt(length);
        while (iterator.moveNext()) {
            message.writeInt((Integer)iterator.current());
        }
        return message;
    }

    public final MsgD getWriterForInt(Transaction a_trans, int id) {
        MsgD message = this.getWriterForLength(a_trans, 4);
        message.writeInt(id);
        return message;
    }

    public final MsgD getWriterForIntString(Transaction a_trans, int anInt, String str) {
        MsgD message = this.getWriterForLength(a_trans, Const4.stringIO.length(str) + 8);
        message.writeInt(anInt);
        message.writeString(str);
        return message;
    }

    public final MsgD getWriterForLong(Transaction a_trans, long a_long) {
        MsgD message = this.getWriterForLength(a_trans, 8);
        message.writeLong(a_long);
        return message;
    }

    public final MsgD getWriterForLongs(Transaction trans, long ... longs) {
        MsgD message = this.getWriterForLength(trans, 8 * longs.length);
        for (int i = 0; i < longs.length; ++i) {
            message.writeLong(longs[i]);
        }
        return message;
    }

    public MsgD getWriterForSingleObject(Transaction trans, Object obj) {
        SerializedGraph serialized = Serializer.marshall(trans.container(), obj);
        MsgD msg = this.getWriterForLength(trans, serialized.marshalledLength());
        serialized.write(msg._payLoad);
        return msg;
    }

    public final MsgD getWriterForString(Transaction a_trans, String str) {
        MsgD message = this.getWriterForLength(a_trans, Const4.stringIO.length(str) + 4);
        message.writeString(str);
        return message;
    }

    public MsgD getWriter(StatefulBuffer bytes) {
        MsgD message = this.getWriterForLength(bytes.transaction(), bytes.length());
        message._payLoad.append(bytes._buffer);
        return message;
    }

    public byte[] readBytes() {
        return this._payLoad.readBytes(this.readInt());
    }

    public final int readInt() {
        return this._payLoad.readInt();
    }

    public final long readLong() {
        return this._payLoad.readLong();
    }

    public final boolean readBoolean() {
        return this._payLoad.readByte() != 0;
    }

    public Object readObjectFromPayLoad() {
        return Serializer.unmarshall(this.container(), this._payLoad);
    }

    final Msg readPayLoad(MessageDispatcher messageDispatcher, Transaction a_trans, Socket4Adapter sock, ByteArrayBuffer reader) {
        int length = reader.readInt();
        a_trans = this.checkParentTransaction(a_trans, reader);
        MsgD command = (MsgD)this.publicClone();
        command.setTransaction(a_trans);
        command.setMessageDispatcher(messageDispatcher);
        command._payLoad = MsgD.readMessageBuffer(a_trans, sock, length);
        return command;
    }

    public final String readString() {
        int length = this.readInt();
        return Const4.stringIO.read(this._payLoad, length);
    }

    public Object readSingleObject() {
        return Serializer.unmarshall(this.container(), SerializedGraph.read(this._payLoad));
    }

    public final void writeBytes(byte[] aBytes) {
        this._payLoad.append(aBytes);
    }

    public final void writeInt(int aInt) {
        this._payLoad.writeInt(aInt);
    }

    public final void writeLong(long l) {
        this._payLoad.writeLong(l);
    }

    public final void writeString(String aStr) {
        this._payLoad.writeInt(aStr.length());
        Const4.stringIO.write(this._payLoad, aStr);
    }
}

