/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.cs.internal.messages;

import com.db4o.cs.internal.ClientObjectContainer;
import com.db4o.cs.internal.messages.ClientSideMessage;
import com.db4o.cs.internal.messages.MsgD;
import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.ObjectInfo;
import com.db4o.ext.ObjectInfoCollection;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.PrimitiveCodec;
import com.db4o.internal.CallbackObjectInfoCollections;
import com.db4o.internal.FrozenObjectInfo;
import com.db4o.internal.LazyObjectReference;
import com.db4o.internal.ObjectInfoCollectionImpl;
import com.db4o.internal.ReflectPlatform;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class MCommittedInfo
extends MsgD
implements ClientSideMessage {
    public MCommittedInfo encode(CallbackObjectInfoCollections callbackInfo, int dispatcherID) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrimitiveCodec.writeInt(os, dispatcherID);
        byte[] bytes = this.encodeInfo(callbackInfo, os);
        MCommittedInfo committedInfo = (MCommittedInfo)this.getWriterForLength(this.transaction(), bytes.length + 4);
        committedInfo._payLoad.append(bytes);
        return committedInfo;
    }

    private byte[] encodeInfo(CallbackObjectInfoCollections callbackInfo, ByteArrayOutputStream os) {
        this.encodeObjectInfoCollection(os, callbackInfo.added, new InternalIDEncoder());
        this.encodeObjectInfoCollection(os, callbackInfo.deleted, new FrozenObjectInfoEncoder());
        this.encodeObjectInfoCollection(os, callbackInfo.updated, new InternalIDEncoder());
        return os.toByteArray();
    }

    private void encodeObjectInfoCollection(ByteArrayOutputStream os, ObjectInfoCollection collection, ObjectInfoEncoder encoder) {
        Iterator4 iter = collection.iterator();
        while (iter.moveNext()) {
            ObjectInfo obj = (ObjectInfo)iter.current();
            encoder.encode(os, obj);
        }
        PrimitiveCodec.writeLong(os, -1L);
    }

    public CallbackObjectInfoCollections decode(ByteArrayInputStream is) {
        ObjectInfoCollection added = this.decodeObjectInfoCollection(is, new InternalIDEncoder());
        ObjectInfoCollection deleted = this.decodeObjectInfoCollection(is, new FrozenObjectInfoEncoder());
        ObjectInfoCollection updated = this.decodeObjectInfoCollection(is, new InternalIDEncoder());
        return new CallbackObjectInfoCollections(added, updated, deleted);
    }

    private ObjectInfoCollection decodeObjectInfoCollection(ByteArrayInputStream is, ObjectInfoEncoder encoder) {
        ObjectInfo info;
        Collection4<ObjectInfo> collection = new Collection4<ObjectInfo>();
        while (null != (info = encoder.decode(is))) {
            collection.add(info);
        }
        return new ObjectInfoCollectionImpl(collection);
    }

    public boolean processAtClient() {
        ByteArrayInputStream is = new ByteArrayInputStream(this._payLoad._buffer);
        final int dispatcherID = PrimitiveCodec.readInt(is);
        final CallbackObjectInfoCollections callbackInfos = this.decode(is);
        this.container().threadPool().start(ReflectPlatform.simpleName(this.getClass()) + ": calling commit callbacks thread", new Runnable(){

            public void run() {
                if (MCommittedInfo.this.container().isClosed()) {
                    return;
                }
                MCommittedInfo.this.container().callbacks().commitOnCompleted(MCommittedInfo.this.transaction(), callbackInfos, dispatcherID == ((ClientObjectContainer)MCommittedInfo.this.container()).serverSideID());
            }
        });
        return true;
    }

    protected void writeByteArray(ByteArrayOutputStream os, byte[] signaturePart) throws IOException {
        PrimitiveCodec.writeLong(os, (long)signaturePart.length);
        os.write(signaturePart);
    }

    static interface ObjectInfoEncoder {
        public void encode(ByteArrayOutputStream var1, ObjectInfo var2);

        public ObjectInfo decode(ByteArrayInputStream var1);
    }

    private final class InternalIDEncoder
    implements ObjectInfoEncoder {
        private InternalIDEncoder() {
        }

        public void encode(ByteArrayOutputStream os, ObjectInfo info) {
            PrimitiveCodec.writeLong(os, info.getInternalID());
        }

        public ObjectInfo decode(ByteArrayInputStream is) {
            long id = PrimitiveCodec.readLong(is);
            if (id == -1L) {
                return null;
            }
            return new LazyObjectReference(MCommittedInfo.this.transaction(), (int)id);
        }
    }

    private final class FrozenObjectInfoEncoder
    implements ObjectInfoEncoder {
        private FrozenObjectInfoEncoder() {
        }

        public void encode(ByteArrayOutputStream os, ObjectInfo info) {
            PrimitiveCodec.writeLong(os, info.getInternalID());
            long sourceDatabaseId = ((FrozenObjectInfo)info).sourceDatabaseId(MCommittedInfo.this.transaction());
            PrimitiveCodec.writeLong(os, sourceDatabaseId);
            PrimitiveCodec.writeLong(os, ((FrozenObjectInfo)info).uuidLongPart());
            PrimitiveCodec.writeLong(os, info.getCommitTimestamp());
        }

        public ObjectInfo decode(ByteArrayInputStream is) {
            long id = PrimitiveCodec.readLong(is);
            if (id == -1L) {
                return null;
            }
            long sourceDatabaseId = PrimitiveCodec.readLong(is);
            Db4oDatabase sourceDatabase = null;
            if (sourceDatabaseId > 0L) {
                sourceDatabase = (Db4oDatabase)MCommittedInfo.this.container().getByID(MCommittedInfo.this.transaction(), sourceDatabaseId);
            }
            long uuidLongPart = PrimitiveCodec.readLong(is);
            long version = PrimitiveCodec.readLong(is);
            return new FrozenObjectInfo(null, id, sourceDatabase, uuidLongPart, version);
        }
    }
}

